/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.utils.ThreeState;

public final class CharsetIMC {
    public static CharsetIMC INSTANCE = new CharsetIMC();
    private final Multimap<String, ResourceLocation> registryLocs = HashMultimap.create();
    private final Multimap<String, String> registryDomainLocs = HashMultimap.create();

    private CharsetIMC() {
    }

    public void loadConfig(Configuration config) {
        String[] sSplit;
        for (String s : ConfigUtils.getStringList(config, "functionalityRegistry", "whitelist", new String[0], "Functionality registry whitelist (example entry: carry:minecraft:bedrock)", true)) {
            sSplit = s.split(":", 2);
            if (sSplit.length >= 2) {
                this.add("w:" + sSplit[0], new ResourceLocation(sSplit[1]));
                continue;
            }
            ModCharset.logger.warn("Invalid functionality registry config entry: " + s);
        }
        for (String s : ConfigUtils.getStringList(config, "functionalityRegistry", "blacklist", new String[0], "Functionality registry blacklist (example entry: carry:minecraft:bedrock)", true)) {
            sSplit = s.split(":", 2);
            if (sSplit.length >= 2) {
                this.add("b:" + sSplit[0], new ResourceLocation(sSplit[1]));
                continue;
            }
            ModCharset.logger.warn("Invalid functionality registry config entry: " + s);
        }
        config.get("functionalityRegistry", "whitelist", new String[0]);
    }

    public ThreeState allows(String key, ResourceLocation location) {
        String bKey = "b:" + key;
        String wKey = "w:" + key;
        if (this.registryLocs.get((Object)bKey).contains(location)) {
            return ThreeState.NO;
        }
        if (this.registryLocs.get((Object)wKey).contains(location)) {
            return ThreeState.YES;
        }
        if (this.registryDomainLocs.get((Object)bKey).contains(location.func_110624_b())) {
            return ThreeState.NO;
        }
        if (this.registryDomainLocs.get((Object)wKey).contains(location.func_110624_b())) {
            return ThreeState.YES;
        }
        return ThreeState.MAYBE;
    }

    public ThreeState allows(String key, Set<ResourceLocation> locations) {
        ThreeState result = ThreeState.MAYBE;
        for (ResourceLocation loc : locations) {
            ThreeState newResult = this.allows(key, loc);
            if (newResult == ThreeState.NO) {
                return ThreeState.NO;
            }
            if (result == ThreeState.YES) continue;
            result = newResult;
        }
        return result;
    }

    private void add(Collection<String> entryKeys, ResourceLocation entry) {
        for (String entryKey : entryKeys) {
            this.add(entryKey, entry);
        }
    }

    private void add(String entryKey, ResourceLocation entry) {
        if (entry.func_110623_a().equals("*")) {
            this.registryDomainLocs.put((Object)entryKey, (Object)entry.func_110624_b());
        } else {
            this.registryLocs.put((Object)entryKey, (Object)entry);
        }
    }

    private String toEntryKey(String entryKey, String prefix) {
        entryKey = entryKey.trim();
        return prefix + entryKey.substring(0, 1).toLowerCase() + entryKey.substring(1);
    }

    private List<String> toList(String entryKey, String prefix) {
        if (entryKey.startsWith("[") && entryKey.endsWith("]")) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : entryKey.substring(1, entryKey.length() - 1).split(",")) {
                keys.add(this.toEntryKey(key, prefix));
            }
            return keys;
        }
        return Lists.newArrayList((Object[])new String[]{this.toEntryKey(entryKey, prefix)});
    }

    public void receiveMessage(FMLInterModComms.IMCMessage msg) {
        for (String key : msg.key.split(";")) {
            List<String> entryKeys;
            if ((key = key.trim()).startsWith("add")) {
                entryKeys = this.toList(key.substring("add".length()), "w:");
                if (!msg.isResourceLocationMessage()) continue;
                this.add(entryKeys, msg.getResourceLocationValue());
                continue;
            }
            if (!key.startsWith("remove")) continue;
            entryKeys = this.toList(key.substring("remove".length()), "b:");
            if (!msg.isResourceLocationMessage()) continue;
            this.add(entryKeys, msg.getResourceLocationValue());
        }
    }
}

