/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.block;

import java.util.Random;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.utils.UtilProxyCommon;
import pl.asie.charset.lib.utils.Utils;

public class PacketCustomBlockDust
extends Packet {
    private static final Random rand = new Random();
    private World world;
    private BlockPos pos;
    private float posX;
    private float posY;
    private float posZ;
    private int numberOfParticles;
    private float particleSpeed;

    public PacketCustomBlockDust() {
    }

    public PacketCustomBlockDust(World world, BlockPos pos, double posX, double posY, double posZ, int numberOfParticles, float particleSpeed) {
        this.world = world;
        this.pos = pos;
        this.posX = (float)posX;
        this.posY = (float)posY;
        this.posZ = (float)posZ;
        this.numberOfParticles = numberOfParticles;
        this.particleSpeed = particleSpeed;
    }

    @Override
    public void readData(INetHandler handler, PacketBuffer buf) {
        int dim = buf.readInt();
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.numberOfParticles = buf.readInt();
        this.posX = buf.readFloat();
        this.posY = buf.readFloat();
        this.posZ = buf.readFloat();
        this.particleSpeed = buf.readFloat();
        this.world = Utils.getLocalWorld(dim);
        this.pos = new BlockPos(x, y, z);
    }

    @Override
    public void apply(INetHandler handler) {
        UtilProxyCommon.proxy.spawnBlockDustClient(this.world, this.pos, rand, this.posX, this.posY, this.posZ, this.numberOfParticles, this.particleSpeed);
    }

    @Override
    public void writeData(PacketBuffer buf) {
        buf.writeInt(this.world.field_73011_w.getDimension());
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.numberOfParticles);
        buf.writeFloat(this.posX);
        buf.writeFloat(this.posY);
        buf.writeFloat(this.posZ);
        buf.writeFloat(this.particleSpeed);
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }
}

