/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.config.ICharsetModuleConfigGui;
import pl.asie.charset.lib.loader.ModuleLoader;

public class ConfigGui
extends GuiConfig {
    public ConfigGui(GuiScreen parentScreen) {
        super(parentScreen, ConfigGui.getConfigElements(), "charset", "Charset", false, false, I18n.func_135052_a((String)"config.charset.title", (Object[])new Object[0]));
    }

    public static List<IConfigElement> generateList(ConfigCategory category) {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        for (Property prop : category.values()) {
            list.add((IConfigElement)new ConfigElement(prop));
        }
        return list;
    }

    public static List<IConfigElement> generateList(Configuration config) {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        for (String name : config.getCategoryNames()) {
            ConfigCategory category = config.getCategory(name);
            list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(category.getName(), category.getLanguagekey(), ConfigGui.generateList(category)));
        }
        return list;
    }

    private static List<IConfigElement> getSubConfigElements(Configuration config, String category, Function<Property, IConfigElement> creator) {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        for (Property prop : config.getCategory(category).values()) {
            list.add(creator.apply(prop));
        }
        return list;
    }

    private static List<IConfigElement> getConfigElements() {
        Configuration config = ModCharset.configModules;
        ArrayList list = Lists.newArrayList((Object[])new IConfigElement[]{new ConfigElement(config.getCategory("general").get("profile")), new DummyConfigElement.DummyCategoryElement("categories", "config.charset.categories.name", ConfigGui.getSubConfigElements(config, "categories", ConfigElement::new)), new DummyConfigElement.DummyCategoryElement("overrides", "config.charset.overrides.name", ConfigGui.getSubConfigElements(config, "overrides", ConfigElement::new))});
        ArrayList modulesWithConfigs = Lists.newArrayList((Iterable)ModuleLoader.moduleConfigs.keySet());
        Collections.sort(modulesWithConfigs);
        for (String s : modulesWithConfigs) {
            List<IConfigElement> clist = null;
            String clsName = ModuleLoader.moduleGuiClasses.get(s);
            if (clsName != null && clsName.length() > 0) {
                try {
                    clist = ((ICharsetModuleConfigGui)Class.forName(clsName).newInstance()).createConfigElements();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (clist == null) {
                clist = ConfigGui.generateList((Configuration)ModuleLoader.moduleConfigs.get((Object)s));
            }
            list.add(new DummyConfigElement.DummyCategoryElement(s, "config.charset." + s + ".name", clist));
        }
        return list;
    }
}

