/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.item;

import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class FontRendererFancy
extends FontRenderer {
    private static final Pattern FANCY_COLOR = Pattern.compile("\ue51a");
    private static final Field LOCATION_FONT_TEXTURE = ReflectionHelper.findField(FontRenderer.class, (String[])new String[]{"locationFontTexture", "field_111273_g"});
    private final FontRenderer parent;

    public FontRendererFancy(FontRenderer parent) throws IllegalAccessException {
        super(Minecraft.func_71410_x().field_71474_y, (ResourceLocation)LOCATION_FONT_TEXTURE.get(parent), Minecraft.func_71410_x().func_110434_K(), parent.func_82883_a());
        this.parent = parent;
    }

    public int func_175065_a(String text, float x, float y, int color, boolean dropShadow) {
        Matcher matcher = FANCY_COLOR.matcher(text);
        int origColor = color;
        int lastPos = 0;
        while (matcher.find()) {
            String subText = text.substring(lastPos, matcher.start());
            x = this.parent.func_175065_a(subText, x, y, color, dropShadow);
            switch (text.charAt(matcher.start() + 1)) {
                case 'C': {
                    color = 0xFF000000 | Integer.parseInt(text.substring(matcher.start() + 2, matcher.start() + 8), 16);
                    lastPos = matcher.start() + 8;
                    break;
                }
                case 'R': {
                    color = origColor;
                    lastPos = matcher.start() + 2;
                }
            }
            if (!dropShadow) continue;
            x -= 1.0f;
        }
        return this.parent.func_175065_a(text.substring(lastPos), x, y, color, dropShadow);
    }

    public static String getColorFormat(int color) {
        return "\ue51aC" + String.format("%06X", color & 0xFFFFFF);
    }

    public static String getColorResetFormat() {
        return "\ue51aR";
    }

    public int func_78256_a(String text) {
        text = text.replaceAll("\ue51aC[0-9a-fA-F]{6}", "");
        text = text.replaceAll("\ue51aR", "");
        return this.parent.func_78256_a(text);
    }

    public int func_78263_a(char character) {
        return this.parent.func_78263_a(character);
    }

    public String func_78262_a(String text, int width, boolean reverse) {
        return this.parent.func_78262_a(text, width, reverse);
    }

    public void func_78279_b(String str, int x, int y, int wrapWidth, int textColor) {
        this.parent.func_78279_b(str, x, y, wrapWidth, textColor);
    }

    public int func_78267_b(String str, int maxLength) {
        return this.parent.func_78267_b(str, maxLength);
    }

    public void func_78264_a(boolean unicodeFlagIn) {
        super.func_78264_a(unicodeFlagIn);
        this.parent.func_78264_a(unicodeFlagIn);
    }

    public void func_78275_b(boolean bidiFlagIn) {
        super.func_78275_b(bidiFlagIn);
        this.parent.func_78275_b(bidiFlagIn);
    }

    public List<String> func_78271_c(String str, int wrapWidth) {
        return this.parent.func_78271_c(str, wrapWidth);
    }
}

