/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import pl.asie.charset.lib.item.SubItemProviderSets;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.utils.ItemStackHashSet;

public class SubItemProviderRecipes
extends SubItemProviderSets {
    private final Supplier<Item> itemSupplier;
    private String group;

    public SubItemProviderRecipes(Supplier<Item> itemSupplier) {
        this(null, itemSupplier);
    }

    public SubItemProviderRecipes(String group, Supplier<Item> itemSupplier) {
        this.group = group;
        this.itemSupplier = itemSupplier;
    }

    @Nullable
    protected List<ItemStack> createSetFor(ItemStack stack) {
        ItemStack newStack = stack.func_77946_l();
        newStack.func_190920_e(1);
        return Collections.singletonList(newStack);
    }

    @Override
    protected List<List<ItemStack>> createItemSets() {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        Item item = this.itemSupplier.get();
        if (this.group == null) {
            this.group = item.getRegistryName().toString();
        }
        ItemStackHashSet stackSet = new ItemStackHashSet(false, true, true);
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            List<ItemStack> stacks;
            if (this.group != null && !this.group.equals(recipe.func_193358_e()) || recipe.func_77571_b().func_190926_b() || recipe.func_77571_b().func_77973_b() != item) continue;
            if (recipe instanceof RecipeCharset) {
                for (ItemStack s : ((RecipeCharset)recipe).getAllRecipeOutputs()) {
                    List<ItemStack> stacks2;
                    if (!stackSet.add(s) || (stacks2 = this.createSetFor(s)) == null || stacks2.size() <= 0) continue;
                    list.add(stacks2);
                }
                continue;
            }
            ItemStack s = recipe.func_77571_b();
            if (!stackSet.add(s) || (stacks = this.createSetFor(s)) == null || stacks.size() <= 0) continue;
            list.add(stacks);
        }
        return list;
    }
}

