/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.material;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.ArrayUtils;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.CharsetLib;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.RecipeUtils;

public final class ItemMaterialHeuristics {
    private static int initPhase = 0;
    private static ItemMaterialRegistry reg;

    private ItemMaterialHeuristics() {
    }

    public static boolean isFullyInitialized() {
        return initPhase >= 2;
    }

    private static boolean isBlock(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof ItemBlock || Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a);
    }

    private static void addResultingBlock(ItemMaterial base, ItemStack result, String source, String target) {
        if (!result.func_190926_b()) {
            result.func_190920_e(1);
            ItemMaterial slabMaterial = reg.getOrCreateMaterial(result);
            if (reg.registerType(slabMaterial, target)) {
                reg.registerRelation(base, slabMaterial, target, source);
                for (String s : base.getTypes()) {
                    if (s.equals(source)) continue;
                    reg.registerType(slabMaterial, s);
                }
            }
        }
    }

    public static ItemStack getCraftingResultQuickly(boolean noShapeless, World world, int width, int height, ItemStack ... stacks) {
        InventoryCrafting crafting = RecipeUtils.getCraftingInventory(width, height, stacks);
        IRecipe recipe = ItemMaterialHeuristics.findMatchingRecipeQuickly(noShapeless, crafting, world);
        if (recipe != null) {
            return recipe.func_77572_b(crafting);
        }
        return ItemStack.field_190927_a;
    }

    public static IRecipe findMatchingRecipeQuickly(boolean noShapeless, InventoryCrafting craftMatrix, World worldIn) {
        int width = craftMatrix.func_174922_i();
        int height = craftMatrix.func_174923_h();
        for (IRecipe irecipe : ForgeRegistries.RECIPES) {
            if (!(irecipe instanceof IShapedRecipe) ? noShapeless && (irecipe instanceof ShapelessRecipes || irecipe instanceof ShapelessOreRecipe || irecipe instanceof RecipeCharset && ((RecipeCharset)irecipe).getType() == RecipeCharset.Type.SHAPELESS) : ((IShapedRecipe)irecipe).getRecipeWidth() != width || ((IShapedRecipe)irecipe).getRecipeHeight() != height) continue;
            if (!irecipe.func_194133_a(width, height) || !irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe;
        }
        return null;
    }

    private static void findSlab(ItemMaterial base) {
        if (!base.getTypes().contains("block") || base.getRelated("slab") != null) {
            return;
        }
        ItemStack slab = ItemMaterialHeuristics.getCraftingResultQuickly(true, null, 3, 1, base.getStack(), base.getStack(), base.getStack());
        if (ItemMaterialHeuristics.isBlock(slab)) {
            ItemMaterialHeuristics.addResultingBlock(base, slab, "block", "slab");
        }
    }

    private static void findStair(ItemMaterial base) {
        if (!base.getTypes().contains("block") || base.getRelated("stairs") != null) {
            return;
        }
        ItemStack stair = ItemMaterialHeuristics.getCraftingResultQuickly(true, null, 3, 3, null, null, base.getStack(), null, base.getStack(), base.getStack(), base.getStack(), base.getStack(), base.getStack());
        if (ItemMaterialHeuristics.isBlock(stair)) {
            ItemMaterialHeuristics.addResultingBlock(base, stair, "block", "stairs");
        }
    }

    private static void initLogMaterial(ItemStack log) {
        ItemMaterial logMaterial;
        if (!ItemMaterialHeuristics.isBlock(log)) {
            return;
        }
        ItemMaterial material = reg.getMaterialIfPresent(log);
        if (material != null && material.getTypes().contains("log")) {
            return;
        }
        ItemStack plank = ItemMaterialHeuristics.getCraftingResultQuickly(false, null, 1, 1, log);
        if (ItemMaterialHeuristics.isBlock(plank) && ItemUtils.isOreType(plank, "plankWood") && reg.registerTypes(logMaterial = reg.getOrCreateMaterial(log), "log", "wood", "block")) {
            plank.func_190920_e(1);
            ItemMaterial plankMaterial = reg.getOrCreateMaterial(plank);
            if (reg.registerTypes(plankMaterial, "plank", "wood", "block")) {
                reg.registerRelation(logMaterial, plankMaterial, "plank", "log");
                ItemStack stick = ItemMaterialHeuristics.getCraftingResultQuickly(true, null, 2, 2, plank, null, plank, null);
                if (stick.func_190926_b()) {
                    stick = new ItemStack(Items.field_151055_y);
                } else {
                    stick.func_190920_e(1);
                }
                ItemMaterial stickMaterial = reg.getOrCreateMaterial(stick);
                if (reg.registerTypes(stickMaterial, "stick", "wood", "item")) {
                    if (stick.func_77973_b() != Items.field_151055_y) {
                        reg.registerRelation(plankMaterial, stickMaterial, "stick", "plank");
                        reg.registerRelation(logMaterial, stickMaterial, "stick", "log");
                    } else {
                        reg.registerRelation(plankMaterial, stickMaterial, "stick");
                        reg.registerRelation(logMaterial, stickMaterial, "stick");
                    }
                }
            }
        }
    }

    private static boolean containsOreDict(ItemStack stack, String entry) {
        return ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)stack), (int)OreDictionary.getOreID((String)entry));
    }

    private static int indexOfUpper(String s, int from) {
        for (int i = from; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.codePointAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static void initIngotLikeMaterial(String oreName, ItemStack stack) {
        int splitPoint = ItemMaterialHeuristics.indexOfUpper(oreName, 0);
        if (splitPoint < 0) {
            return;
        }
        String prefix = oreName.substring(0, splitPoint);
        String suffixU = oreName.substring(splitPoint);
        String suffix = suffixU.substring(0, 1).toLowerCase() + suffixU.substring(1);
        ItemMaterial ingotMat = reg.getOrCreateMaterial(stack);
        if (prefix.equals("ingot") && suffix.startsWith("brick")) {
            if (reg.registerTypes(ingotMat, "brick", "item")) {
                ItemStack block;
                int splitPoint2 = ItemMaterialHeuristics.indexOfUpper(suffix, 1);
                if (splitPoint2 >= 0) {
                    String suffixU2 = suffix.substring(splitPoint2);
                    String suffix2 = suffixU2.substring(0, 1).toLowerCase() + suffixU2.substring(1);
                    reg.registerType(ingotMat, suffix2);
                }
                if (!(block = ItemMaterialHeuristics.getCraftingResultQuickly(true, null, 2, 2, stack, stack, stack, stack)).func_190926_b() && block.func_77973_b() instanceof ItemBlock) {
                    ItemMaterial blockMat = reg.getOrCreateMaterial(block);
                    reg.registerTypes(blockMat, suffix, "block");
                    reg.registerRelation(ingotMat, blockMat, "block", prefix);
                }
            }
            return;
        }
        if (reg.registerTypes(ingotMat, prefix, suffix, "item")) {
            ItemStack block;
            ItemStack nugget;
            if (prefix.equals("ingot") && !(nugget = ItemMaterialHeuristics.getCraftingResultQuickly(false, null, 1, 1, stack)).func_190926_b() && ItemMaterialHeuristics.containsOreDict(nugget, "nugget" + suffixU)) {
                ItemMaterial nuggetMat = reg.getOrCreateMaterial(nugget);
                reg.registerTypes(nuggetMat, "nugget", suffix, "item");
                reg.registerRelation(ingotMat, nuggetMat, "nugget", prefix);
            }
            if (!(block = ItemMaterialHeuristics.getCraftingResultQuickly(false, null, 3, 3, stack, stack, stack, stack, stack, stack, stack, stack, stack)).func_190926_b() && ItemMaterialHeuristics.containsOreDict(block, "block" + suffixU)) {
                ItemMaterial blockMat = reg.getOrCreateMaterial(block);
                reg.registerTypes(blockMat, suffix, "block");
                reg.registerRelation(ingotMat, blockMat, "block", prefix);
            }
        }
    }

    private static void initOreMaterial(String oreName) {
        String prefix = "ore";
        String suffixU = oreName.substring(prefix.length());
        String suffix = suffixU.substring(0, 1).toLowerCase() + suffixU.substring(1);
        ItemMaterialHeuristics.supplyExpandedStacks((Collection<ItemStack>)OreDictionary.getOres((String)oreName), stack -> {
            if (ItemMaterialHeuristics.isBlock(stack)) {
                ItemMaterial oreMaterial = reg.getOrCreateMaterial((ItemStack)stack);
                reg.registerTypes(oreMaterial, prefix, suffix, "block");
            }
        });
    }

    private static void initStoneMaterial(String oreName, ItemStack stack) {
        ItemStack block;
        if (oreName.endsWith("Polished") || !ItemMaterialHeuristics.isBlock(stack)) {
            return;
        }
        String prefix = "stone";
        String suffixU = oreName.substring(prefix.length());
        String suffix = suffixU.length() > 0 ? suffixU.substring(0, 1).toLowerCase() + suffixU.substring(1) : "";
        ItemMaterial stoneMat = reg.getOrCreateMaterial(stack);
        if (reg.registerTypes(stoneMat, "stone", suffix, "block") && !(block = ItemMaterialHeuristics.getCraftingResultQuickly(true, null, 2, 2, stack, stack, stack, stack)).func_190926_b()) {
            ItemMaterial brickMat = reg.getOrCreateMaterial(block);
            reg.registerTypes(brickMat, "stone", "brick", suffix, "block");
            reg.registerRelation(stoneMat, brickMat, "brick", "parent");
        }
    }

    private static void initCobblestoneMaterial(String oreName, ItemStack stack) {
        ItemMaterial cobbleMat = reg.getOrCreateMaterial(stack);
        reg.registerTypes(cobbleMat, "cobblestone", "block");
        ItemStack stoneStack = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        ItemMaterial stoneMaterial = reg.getMaterialIfPresent(stoneStack);
        if (stoneMaterial == null) {
            ModCharset.logger.warn("Found OreDict cobblestone which does not give OreDict stone -> " + cobbleMat.toString());
        } else {
            reg.registerRelation(cobbleMat, stoneMaterial, "stone", "cobblestone");
        }
    }

    private static void supplyExpandedStacks(Collection<ItemStack> stacks, Consumer<ItemStack> stackConsumer) {
        for (ItemStack log : stacks) {
            try {
                if (log.func_77960_j() == Short.MAX_VALUE) {
                    NonNullList stackList = NonNullList.func_191196_a();
                    log.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, stackList);
                    for (int i = 0; i < stackList.size(); ++i) {
                        stackConsumer.accept((ItemStack)stackList.get(i));
                    }
                    continue;
                }
                stackConsumer.accept(log.func_77946_l());
            }
            catch (Exception exception) {}
        }
    }

    public static void init(boolean modded) {
        if (initPhase >= (modded ? 2 : 1)) {
            return;
        }
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Material scanning", (int)6);
        reg = ItemMaterialRegistry.INSTANCE;
        initPhase = modded ? 2 : 1;
        bar.step("Wood");
        if (!modded) {
            for (int i = 0; i < 6; ++i) {
                ItemMaterial log = reg.getOrCreateMaterial(new ItemStack(i >= 4 ? Blocks.field_150363_s : Blocks.field_150364_r, 1, i % 4));
                ItemMaterial plank = reg.getOrCreateMaterial(new ItemStack(Blocks.field_150344_f, 1, i));
                ItemMaterial stick = reg.getOrCreateMaterial(new ItemStack(Items.field_151055_y));
                reg.registerTypes(log, "log", "block", "wood");
                reg.registerTypes(plank, "plank", "block", "wood");
                reg.registerTypes(stick, "stick", "item", "wood");
                reg.registerRelation(log, plank, "plank", "log");
                if (i == 0) {
                    reg.registerRelation(plank, stick, "stick", "plank");
                    reg.registerRelation(log, stick, "stick", "log");
                    continue;
                }
                reg.registerRelation(plank, stick, "stick");
                reg.registerRelation(log, stick, "stick");
            }
        } else {
            ItemMaterialHeuristics.supplyExpandedStacks((Collection<ItemStack>)OreDictionary.getOres((String)"logWood", (boolean)false), ItemMaterialHeuristics::initLogMaterial);
        }
        bar.step("Ores");
        if (modded) {
            for (String oreName : OreDictionary.getOreNames()) {
                if (!oreName.startsWith("ore")) continue;
                ItemMaterialHeuristics.initOreMaterial(oreName);
            }
        }
        bar.step("Ingots/Dusts/Gems");
        if (modded) {
            for (String oreName : OreDictionary.getOreNames()) {
                if (!oreName.startsWith("ingot") && !oreName.startsWith("dust") && !oreName.startsWith("gem")) continue;
                ItemMaterialHeuristics.supplyExpandedStacks((Collection<ItemStack>)OreDictionary.getOres((String)oreName, (boolean)false), s -> ItemMaterialHeuristics.initIngotLikeMaterial(oreName, s));
            }
        }
        bar.step("Stones");
        if (modded) {
            for (String oreName : OreDictionary.getOreNames()) {
                if (!oreName.startsWith("stone")) continue;
                ItemMaterialHeuristics.supplyExpandedStacks((Collection<ItemStack>)OreDictionary.getOres((String)oreName, (boolean)false), s -> ItemMaterialHeuristics.initStoneMaterial(oreName, s));
            }
            for (String oreName : OreDictionary.getOreNames()) {
                if (!oreName.startsWith("cobblestone")) continue;
                ItemMaterialHeuristics.supplyExpandedStacks((Collection<ItemStack>)OreDictionary.getOres((String)oreName, (boolean)false), s -> ItemMaterialHeuristics.initCobblestoneMaterial(oreName, s));
            }
        }
        bar.step("Misc");
        if (modded) {
            reg.registerTypes(reg.getOrCreateMaterial(new ItemStack(Blocks.field_150357_h)), "block", "bedrock");
        }
        bar.step("Slabs/Stairs");
        for (ItemMaterial material : reg.getMaterialsByType("block")) {
            ItemMaterialHeuristics.findSlab(material);
            ItemMaterialHeuristics.findStair(material);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        if (CharsetLib.enableDebugInfo && initPhase == 2) {
            try {
                File outputFile = new File("charsetItemMaterials.txt");
                PrintWriter writer = new PrintWriter(outputFile);
                Joiner commaJoiner = Joiner.on((String)",");
                for (ItemMaterial material : reg.getAllMaterials()) {
                    writer.println(material.getId());
                    writer.println("- Types: " + commaJoiner.join(material.getTypes()));
                    for (Map.Entry entry : ItemMaterialRegistry.INSTANCE.materialRelations.row((Object)material).entrySet()) {
                        writer.println("- Relation: " + (String)entry.getKey() + " -> " + ((ItemMaterial)entry.getValue()).getId());
                    }
                }
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

