/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.material;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.utils.ItemUtils;

public class ItemMaterialRegistry {
    public static final ItemMaterialRegistry INSTANCE = new ItemMaterialRegistry();
    private final Map<String, ItemMaterial> materialsById = new HashMap<String, ItemMaterial>();
    private final LinkedListMultimap<String, ItemMaterial> materialsByType = LinkedListMultimap.create();
    private final Multimap<ItemMaterial, String> materialTypes = MultimapBuilder.hashKeys().hashSetValues().build();
    protected final Table<ItemMaterial, String, ItemMaterial> materialRelations = HashBasedTable.create();

    protected ItemMaterialRegistry() {
    }

    private ItemMaterial getMaterialIfPresent(NBTTagCompound tag, String name) {
        ItemMaterial result = null;
        if (tag != null && tag.func_74764_b(name)) {
            ItemStack stack;
            NBTBase nameTag = tag.func_74781_a(name);
            if (nameTag instanceof NBTTagString) {
                result = this.getMaterial(((NBTTagString)nameTag).func_150285_a_());
            } else if (nameTag instanceof NBTTagCompound && !(stack = new ItemStack((NBTTagCompound)nameTag)).func_190926_b()) {
                result = this.getOrCreateMaterial(stack);
            }
        }
        return result;
    }

    public ItemMaterial getMaterial(NBTTagCompound tag, String name) {
        return this.getMaterial(tag, name, null);
    }

    public ItemMaterial getMaterial(NBTTagCompound tag, String name, String defaultType) {
        ItemMaterial result = this.getMaterialIfPresent(tag, name);
        return result == null ? (defaultType != null ? this.getDefaultMaterialByType(defaultType) : null) : result;
    }

    public ItemMaterial getMaterial(NBTTagCompound tag, String name, String defaultType, ItemStack defaultStack) {
        ItemMaterial result = this.getMaterialIfPresent(tag, name);
        if (result == null) {
            result = this.getMaterialIfPresent(defaultStack);
        }
        return result == null ? (defaultType != null ? this.getDefaultMaterialByType(defaultType) : null) : result;
    }

    public static final String createId(ItemStack stack) {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(stack.func_77973_b().getRegistryName());
        idBuilder.append(';');
        idBuilder.append(stack.func_77960_j());
        if (stack.func_77942_o()) {
            idBuilder.append(';');
            idBuilder.append(stack.func_77978_p().toString());
        }
        return idBuilder.toString();
    }

    public ItemMaterial getDefaultMaterialByType(String type) {
        List materials = this.materialsByType.get((Object)type);
        return materials != null && materials.size() > 0 ? (ItemMaterial)materials.get(0) : null;
    }

    public Collection<ItemMaterial> getMaterialsByType(String type) {
        return this.materialsByType.get((Object)type);
    }

    public Collection<ItemMaterial> getMaterialsByTypes(String ... types) {
        ImmutableSet.Builder set = new ImmutableSet.Builder();
        for (ItemMaterial material : this.materialsById.values()) {
            Collection<String> srcTypes = material.getTypes();
            boolean valid = true;
            for (String type : types) {
                if (type.charAt(0) == '!') {
                    if (!srcTypes.contains(type.substring(1))) continue;
                    valid = false;
                    break;
                }
                if (srcTypes.contains(type)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            set.add((Object)material);
        }
        return set.build();
    }

    public ItemMaterial getMaterial(String id) {
        return this.materialsById.get(id);
    }

    public Collection<String> getMaterialTypes(ItemMaterial material) {
        return this.materialTypes.get((Object)material);
    }

    public ItemMaterial getMaterialIfPresent(ItemStack stack) {
        return this.materialsById.get(ItemMaterialRegistry.createId(stack));
    }

    public ItemMaterial getOrCreateMaterial(ItemStack stack) {
        ItemMaterial material = this.getMaterialIfPresent(stack);
        if (material == null) {
            material = new ItemMaterial(stack);
            this.materialsById.put(material.getId(), material);
        }
        return material;
    }

    public boolean registerTypes(ItemMaterial material, String ... types) {
        boolean result = false;
        for (String type : types) {
            result |= this.registerType(material, type);
        }
        return result;
    }

    public boolean registerType(ItemMaterial material, String type) {
        if (type.length() > 0 && !this.materialTypes.containsEntry((Object)material, (Object)type)) {
            this.materialTypes.put((Object)material, (Object)type);
            this.materialsByType.put((Object)type, (Object)material);
            return true;
        }
        return false;
    }

    public boolean registerRelation(ItemMaterial source, ItemMaterial target, String relation, String invRelation) {
        return this.registerRelation(source, target, relation) && this.registerRelation(target, source, invRelation);
    }

    public boolean registerRelation(ItemMaterial source, ItemMaterial target, String relation) {
        this.materialRelations.put((Object)source, (Object)relation, (Object)target);
        return true;
    }

    public Collection<String> getAllTypes() {
        return this.materialsByType.keySet();
    }

    public Collection<ItemMaterial> getAllMaterials() {
        return this.materialsById.values();
    }

    public boolean matches(ItemStack stack, ItemMaterial mat) {
        return ItemUtils.canMerge(mat.getStack(), stack);
    }

    public boolean matches(ItemMaterial mat, String ... mats) {
        for (String matStr : mats) {
            if (matStr.startsWith("!")) {
                matStr = matStr.substring(1);
                if (!mat.getTypes().contains(matStr)) continue;
                return false;
            }
            if (mat.getTypes().contains(matStr)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(ItemStack stack, String ... mats) {
        ItemMaterial material = this.getMaterialIfPresent(stack);
        if (material != null) {
            return this.matches(material, mats);
        }
        return false;
    }
}

