/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import javax.annotation.CheckReturnValue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import pl.asie.charset.lib.notify.INoticeUpdater;
import pl.asie.charset.lib.notify.NoticeStyle;
import pl.asie.charset.lib.notify.NotificationCoord;
import pl.asie.charset.lib.notify.NotifyImplementation;
import pl.asie.charset.lib.utils.ItemUtils;

public class Notice {
    final Object where;
    private ITextComponent message;
    private ItemStack item = ItemStack.field_190927_a;
    private EnumSet<NoticeStyle> style = EnumSet.noneOf(NoticeStyle.class);
    private INoticeUpdater updater;
    private boolean isUpdating = false;
    private int age = 0;
    private boolean changed = false;
    private boolean changedItem = false;
    private boolean addedToRecurList = false;
    EntityPlayer targetPlayer = null;
    World world;
    private static final String[] emptyStringArray = new String[0];

    @CheckReturnValue
    public Notice(Object where, ITextComponent message) {
        this.where = where;
        this.message = message;
        if (where instanceof NotificationCoord) {
            this.world = ((NotificationCoord)where).getWorld();
        } else if (where instanceof Entity) {
            this.world = ((Entity)where).field_70170_p;
        } else if (where instanceof TileEntity) {
            this.world = ((TileEntity)where).func_145831_w();
        }
    }

    @CheckReturnValue
    public Notice(Object where, INoticeUpdater updater) {
        this.where = where;
        this.withUpdater(updater);
        updater.update(this);
    }

    @CheckReturnValue
    public Notice withItem(ItemStack item) {
        if (this.isUpdating && !this.changed) {
            this.cmpIs(this.item, item);
            this.changedItem |= this.changed;
        }
        ItemStack itemStack = this.item = item.func_190926_b() ? ItemStack.field_190927_a : item.func_77946_l();
        if (this.item.func_190916_E() > this.item.func_77976_d()) {
            this.item.func_190920_e(item.func_77976_d());
        }
        return this;
    }

    @CheckReturnValue
    public Notice withStyle(NoticeStyle ... styles) {
        boolean addedStyle = false;
        for (NoticeStyle s : styles) {
            addedStyle |= this.style.add(s);
        }
        if (addedStyle && this.isUpdating) {
            this.changed = true;
        }
        return this;
    }

    public Notice withStyle(Collection<NoticeStyle> styles) {
        boolean addedStyle = false;
        for (NoticeStyle s : styles) {
            addedStyle |= this.style.add(s);
        }
        if (addedStyle && this.isUpdating) {
            this.changed = true;
        }
        return this;
    }

    @CheckReturnValue
    public Notice withWorld(World world) {
        this.world = world;
        return this;
    }

    @CheckReturnValue
    public Notice withUpdater(INoticeUpdater updater) {
        this.updater = updater;
        return this;
    }

    public Notice setMessage(ITextComponent newMessage) {
        this.cmp(this.message, newMessage);
        this.message = newMessage;
        return this;
    }

    private void cmp(Object a, Object b) {
        if (a == b) {
            return;
        }
        this.changed = a != null && b != null ? (this.changed |= !a.equals(b)) : true;
    }

    private void cmpIs(ItemStack a, ItemStack b) {
        this.changed |= ItemUtils.equalsMeta(a, b);
    }

    int getLifetime() {
        if (this.style.contains((Object)NoticeStyle.VERY_LONG)) {
            return 60;
        }
        if (this.style.contains((Object)NoticeStyle.LONG)) {
            return 11;
        }
        return 6;
    }

    boolean isInvalid() {
        Vec3d vec;
        NotificationCoord coord;
        TileEntity te;
        int maxAge = 20 * this.getLifetime();
        if (this.age++ > maxAge) {
            return true;
        }
        if (this.where instanceof Entity) {
            Entity ent = (Entity)this.where;
            if (ent.field_70128_L) {
                return false;
            }
        } else if (this.where instanceof TileEntity ? (te = (TileEntity)this.where).func_145837_r() : (this.where instanceof NotificationCoord ? !(coord = (NotificationCoord)this.where).getWorld().func_175667_e(coord.getPos()) : this.where instanceof Vec3d && this.world != null && !this.world.func_175667_e(new BlockPos(vec = (Vec3d)this.where)))) {
            return false;
        }
        if (this.targetPlayer != null) {
            return this.targetPlayer.field_70128_L;
        }
        return false;
    }

    public void sendTo(EntityPlayer player) {
        if (this.isUpdating) {
            return;
        }
        if (this.world == null && player != null) {
            this.world = player.field_70170_p;
        }
        NotifyImplementation.instance.doSend(player, this.where, this.world, this.style, this.item, this.message);
        this.changed = false;
        this.changedItem = false;
        if (this.updater != null && !this.addedToRecurList) {
            NotifyImplementation.instance.addRecuringNotification(this);
            this.targetPlayer = player;
            this.addedToRecurList = true;
        }
    }

    public void sendToAll() {
        this.sendTo(null);
    }

    public static void clear(EntityPlayer player) {
        NotificationCoord at = new NotificationCoord(player.field_70170_p, new BlockPos((Entity)player));
        NotifyImplementation.instance.doSend(player, at, player.field_70170_p, EnumSet.of(NoticeStyle.CLEAR), null, (ITextComponent)new TextComponentString(""));
    }

    public static void onscreen(EntityPlayer player, Collection<NoticeStyle> styles, ITextComponent msg) {
        NotifyImplementation.instance.doSendOnscreenMessage(player, styles, msg);
    }

    public static void title(EntityPlayer player, String title, String subtitle) {
        Notice.onscreen(player, Collections.emptySet(), (ITextComponent)new TextComponentString(title + "\n" + subtitle));
    }

    public static void title(EntityPlayer player, String title) {
        Notice.onscreen(player, Collections.emptySet(), (ITextComponent)new TextComponentString(title));
    }

    boolean updateNotice() {
        if (this.updater == null) {
            return false;
        }
        if (this.targetPlayer != null && this.targetPlayer.field_70128_L) {
            return false;
        }
        if (this.isUpdating) {
            return false;
        }
        this.isUpdating = true;
        this.updater.update(this);
        this.isUpdating = false;
        if (this.changed) {
            if (this.changedItem) {
                this.style.add(NoticeStyle.UPDATE);
                this.sendTo(this.targetPlayer);
                this.style.remove((Object)NoticeStyle.UPDATE);
            } else {
                this.style.add(NoticeStyle.UPDATE_SAME_ITEM);
                this.sendTo(this.targetPlayer);
                this.style.remove((Object)NoticeStyle.UPDATE_SAME_ITEM);
            }
            this.changedItem = false;
            this.changed = false;
        }
        return true;
    }

    public void cancel() {
        this.age = this.getLifetime();
    }
}

