/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.NoticeStyle;
import pl.asie.charset.lib.notify.NotificationCoord;

public class PacketPoint
extends Packet {
    private EntityPlayer player;
    private Type type;
    private BlockPos pos;
    private Entity entity;
    private String message;

    public static PacketPoint atCoord(BlockPos pos, String message) {
        PacketPoint packetPoint = new PacketPoint();
        packetPoint.type = Type.COORD;
        packetPoint.message = message;
        packetPoint.pos = pos;
        return packetPoint;
    }

    public static PacketPoint atEntity(Entity entity, String message) {
        PacketPoint packetPoint = new PacketPoint();
        packetPoint.type = Type.ENTITY;
        packetPoint.message = message;
        packetPoint.entity = entity;
        return packetPoint;
    }

    @Override
    public void readData(INetHandler handler, PacketBuffer buf) {
        this.player = PacketPoint.getPlayer(handler);
        this.type = Type.VALUES[buf.readByte()];
        this.message = this.buildMessage(this.player, (ByteBuf)buf);
        switch (this.type) {
            case COORD: {
                this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
                break;
            }
            case ENTITY: {
                this.entity = this.player.field_70170_p.func_73045_a(buf.readInt());
            }
        }
    }

    @Override
    public void apply(INetHandler handler) {
        if (this.player == null) {
            return;
        }
        Notice notice = null;
        switch (this.type) {
            case COORD: {
                notice = new Notice((Object)new NotificationCoord(this.player.field_70170_p, this.pos), (ITextComponent)new TextComponentString(this.message));
                break;
            }
            case ENTITY: {
                notice = new Notice((Object)this.entity, (ITextComponent)new TextComponentString(this.message));
            }
        }
        notice.withStyle(NoticeStyle.DRAWFAR, NoticeStyle.VERY_LONG, NoticeStyle.SCALE_SIZE, NoticeStyle.EXACTPOSITION);
        double maxDistSq = 65536.0;
        for (EntityPlayer viewer : this.player.field_70170_p.field_73010_i) {
            if (this.player.func_70068_e((Entity)viewer) >= maxDistSq) continue;
            notice.sendTo(viewer);
        }
    }

    @Override
    public void writeData(PacketBuffer buf) {
        buf.writeByte(this.type.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.message);
        switch (this.type) {
            case COORD: {
                buf.writeInt(this.pos.func_177958_n());
                buf.writeInt(this.pos.func_177956_o());
                buf.writeInt(this.pos.func_177952_p());
                break;
            }
            case ENTITY: {
                buf.writeInt(this.entity.func_145782_y());
            }
        }
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }

    private String buildMessage(EntityPlayer player, ByteBuf input) {
        String base = "<" + player.func_70005_c_() + ">";
        String msg = ByteBufUtils.readUTF8String((ByteBuf)input);
        if (msg == null || msg.length() == 0) {
            return base;
        }
        return base + "\n" + msg;
    }

    static enum Type {
        COORD,
        ENTITY;

        static Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

