/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import pl.asie.charset.lib.recipe.IngredientCharset;

public class IngredientMatcher {
    private final Container container;
    private final Map<Ingredient, ItemStack> matchedStacks = new HashMap<Ingredient, ItemStack>();

    public IngredientMatcher(Container container) {
        this.container = container;
    }

    public Collection<Ingredient> getMatchedIngredients() {
        return this.matchedStacks.keySet();
    }

    public Ingredient getIngredient(char c) {
        return this.container.getIngredient(c);
    }

    public ItemStack getStack(Ingredient i) {
        return this.matchedStacks.getOrDefault(i, ItemStack.field_190927_a);
    }

    public boolean add(ItemStack stack, Ingredient ingredient) {
        if (ingredient == Ingredient.field_193370_a) {
            return stack.func_190926_b();
        }
        boolean match = false;
        if (ingredient instanceof IngredientCharset) {
            IngredientCharset ic = (IngredientCharset)ingredient;
            if (((IngredientCharset)ingredient).apply(this, stack)) {
                if (this.matchedStacks.containsKey(ingredient) && !ic.areItemStacksMatched(this.matchedStacks.get(ingredient), stack)) {
                    return false;
                }
                match = true;
            }
        } else {
            match = ingredient.apply(stack);
        }
        if (match) {
            this.matchedStacks.put(ingredient, stack);
            return true;
        }
        return false;
    }

    public ItemStack apply(ItemStack stack) {
        boolean applied = false;
        for (Map.Entry<Ingredient, ItemStack> entry : this.matchedStacks.entrySet()) {
            if (!(entry.getKey() instanceof IngredientCharset)) continue;
            if (!applied) {
                applied = true;
                stack = stack.func_77946_l();
            }
            ((IngredientCharset)entry.getKey()).applyToStack(stack, entry.getValue());
        }
        return stack;
    }

    public static interface Container {
        public Ingredient getIngredient(char var1);
    }
}

