/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.oredict.OreIngredient;
import pl.asie.charset.lib.recipe.IngredientCharset;
import pl.asie.charset.lib.recipe.RecipeCharset;

public class InventoryCraftingIterator
extends InventoryCrafting
implements Iterator<InventoryCrafting> {
    protected final RecipeCharset recipe;
    protected final Map<Ingredient, ItemStack[]> permutatingIngredients = new LinkedHashMap<Ingredient, ItemStack[]>();
    protected final Object[] inputReal;
    protected int i;
    protected int permutations;

    public InventoryCraftingIterator(RecipeCharset recipe, boolean permutateAll) {
        super(new net.minecraft.inventory.Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return false;
            }
        }, recipe.width, recipe.height);
        this.recipe = recipe;
        this.i = 0;
        this.permutations = 1;
        this.inputReal = new Object[recipe.input.size()];
        for (int i = 0; i < recipe.input.size(); ++i) {
            Class<?> c;
            ItemStack[] stacks;
            Ingredient ing = (Ingredient)recipe.input.get(i);
            if (this.permutatingIngredients.containsKey(ing) || (stacks = ing.func_193365_a()).length <= 1 || !permutateAll && (ing instanceof IngredientCharset && !((IngredientCharset)ing).mustIteratePermutations() || (c = ing.getClass()) == Ingredient.class || c == IngredientNBT.class || c == OreIngredient.class)) continue;
            this.permutatingIngredients.put(ing, stacks);
            this.permutations *= stacks.length;
        }
    }

    @Override
    public boolean hasNext() {
        return this.i < this.permutations;
    }

    @Override
    public InventoryCrafting next() {
        ItemStack[] stacks;
        int permPos = this.i;
        HashMap<Ingredient, ItemStack> stackMap = new HashMap<Ingredient, ItemStack>();
        for (Map.Entry<Ingredient, ItemStack[]> entry : this.permutatingIngredients.entrySet()) {
            stacks = entry.getValue();
            stackMap.put(entry.getKey(), stacks[permPos % stacks.length]);
            permPos /= stacks.length;
        }
        for (int i = 0; i < this.recipe.input.size(); ++i) {
            Ingredient ing = (Ingredient)this.recipe.input.get(i);
            if (this.permutatingIngredients.containsKey(ing)) {
                this.func_70299_a(i, (ItemStack)stackMap.get(ing));
                this.inputReal[i] = stackMap.get(ing);
                continue;
            }
            stacks = ing.func_193365_a();
            this.func_70299_a(i, stacks.length > 0 ? stacks[0] : ItemStack.field_190927_a);
            this.inputReal[i] = ing;
        }
        ++this.i;
        return this;
    }

    public Container contain() {
        return new Container(this);
    }

    public static class Container {
        private final List stacks;
        private final Collection<ItemStack> output;
        private final RecipeCharset base;

        private Container(InventoryCraftingIterator iterator) {
            this.base = iterator.recipe;
            this.stacks = new ArrayList();
            for (int i = 0; i < iterator.recipe.input.size(); ++i) {
                this.stacks.add(iterator.inputReal[i]);
            }
            this.output = iterator.permutations == 1 ? iterator.recipe.getAllRecipeOutputs() : Collections.singletonList(iterator.recipe.func_77572_b(iterator));
        }

        public List getInputs() {
            return this.stacks;
        }

        public Collection<ItemStack> getOutput() {
            return this.output;
        }

        public boolean isShapeless() {
            return this.base.getType() == RecipeCharset.Type.SHAPELESS;
        }

        public int getWidth() {
            return this.base.getWidth();
        }

        public int getHeight() {
            return this.base.getHeight();
        }
    }
}

