/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import pl.asie.charset.lib.recipe.IOutputSupplier;
import pl.asie.charset.lib.recipe.IOutputSupplierFactory;
import pl.asie.charset.lib.recipe.IngredientMatcher;
import pl.asie.charset.lib.recipe.RecipeCharset;

public class OutputSupplier {
    private static final Gson GSON = new Gson();
    private static final Map<String, IOutputSupplierFactory> outputSuppliers = Maps.newHashMap();
    private static boolean initialized;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFactories(ModContainer container) {
        File file = container.getSource();
        try {
            BufferedReader reader;
            if (!file.exists()) return;
            if (file.isDirectory()) {
                File f = new File(file, "assets/" + container.getModId() + "/recipes/_factories.json");
                if (!f.exists()) return;
                reader = Files.newBufferedReader(f.toPath());
            } else {
                FileSystem fileSystem = FileSystems.newFileSystem(file.toPath(), null);
                Path p = fileSystem.getPath("assets/" + container.getModId() + "/recipes/_factories.json", new String[0]);
                reader = Files.newBufferedReader(p, Charsets.UTF_8);
            }
            JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            if (json == null || !json.has("charset:output_suppliers")) return;
            JsonObject object = JsonUtils.func_152754_s((JsonObject)json, (String)"charset:output_suppliers");
            for (Map.Entry entry : object.entrySet()) {
                String key = new ResourceLocation(container.getModId(), (String)entry.getKey()).toString();
                String value = ((JsonElement)entry.getValue()).getAsString();
                Object o = Class.forName(value).newInstance();
                if (o instanceof IOutputSupplierFactory) {
                    outputSuppliers.put(key, (IOutputSupplierFactory)o);
                    continue;
                }
                if (!(o instanceof IOutputSupplier)) throw new Exception("Invalid OutputSupplier object type: " + (o != null ? o.getClass().getName() : "null"));
                outputSuppliers.put(key, (a, b) -> (IOutputSupplier)o);
            }
            return;
        }
        catch (FileSystemNotFoundException | NoSuchFileException reader) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        Loader.instance().getActiveModList().forEach(OutputSupplier::loadFactories);
        initialized = true;
    }

    public static IOutputSupplier createOutputSupplier(JsonContext context, JsonObject json) {
        OutputSupplier.initialize();
        if (json.has("supplier")) {
            return outputSuppliers.get(JsonUtils.func_151200_h((JsonObject)json, (String)"supplier")).parse(context, json);
        }
        return new Stack(CraftingHelper.getItemStack((JsonObject)json, (JsonContext)context));
    }

    public static IOutputSupplier createStackOutputSupplier(ItemStack stack) {
        return new Stack(stack);
    }

    private static class Stack
    implements IOutputSupplier {
        private final ItemStack stack;

        Stack(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public ItemStack getCraftingResult(RecipeCharset recipe, IngredientMatcher matcher, InventoryCrafting inv) {
            return this.stack;
        }

        @Override
        public ItemStack getDefaultOutput() {
            return this.stack;
        }
    }
}

