/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gnu.trove.iterator.TCharIterator;
import gnu.trove.map.TCharObjectMap;
import gnu.trove.map.hash.TCharObjectHashMap;
import gnu.trove.map.hash.TObjectCharHashMap;
import gnu.trove.set.TCharSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.crafting.JsonContext;
import pl.asie.charset.lib.recipe.IOutputSupplier;
import pl.asie.charset.lib.recipe.IngredientCharset;
import pl.asie.charset.lib.recipe.IngredientMatcher;
import pl.asie.charset.lib.recipe.InventoryCraftingIterator;
import pl.asie.charset.lib.recipe.OutputSupplier;
import pl.asie.charset.lib.recipe.RecipeBase;
import pl.asie.charset.lib.utils.ItemStackHashSet;

public class RecipeCharset
extends RecipeBase
implements IngredientMatcher.Container {
    protected final boolean shapeless = !(this instanceof Shaped);
    protected IOutputSupplier output;
    protected final TCharObjectMap<Ingredient> charToIngredient = new TCharObjectHashMap();
    protected int[] shapedOrdering;
    protected NonNullList<Ingredient> input = null;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = false;

    public RecipeCharset(JsonContext context, JsonObject object) {
        super(context, object);
    }

    public RecipeCharset(String group) {
        super(group);
    }

    public RecipeCharset(String group, boolean hidden) {
        super(group, hidden);
    }

    public Collection<ItemStack> getAllRecipeOutputs() {
        InventoryCraftingIterator inventoryCrafting = new InventoryCraftingIterator(this, true);
        ItemStackHashSet stackSet = new ItemStackHashSet(true, true, true);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        InventoryCraftingIterator it = inventoryCrafting;
        while (it.hasNext()) {
            InventoryCrafting ic = it.next();
            ItemStack stack = this.func_77572_b(ic);
            if (stack.func_190926_b() || !stackSet.add(stack)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.input;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Type getType() {
        return this.shapeless ? Type.SHAPELESS : Type.SHAPED;
    }

    protected IngredientMatcher matchedOrNull(InventoryCrafting inv) {
        if (this.shapeless) {
            HashSet<Ingredient> objectSet = new HashSet<Ingredient>();
            objectSet.addAll((Collection<Ingredient>)this.input);
            IngredientMatcher matcher = new IngredientMatcher(this);
            for (int y = 0; y < inv.func_174923_h(); ++y) {
                for (int x = 0; x < inv.func_174922_i(); ++x) {
                    ItemStack stack = inv.func_70463_b(x, y);
                    if (stack.func_190926_b()) continue;
                    boolean matches = false;
                    for (Ingredient o : objectSet) {
                        if (!o.apply(stack)) continue;
                        matches = true;
                        matcher.add(stack, o);
                        objectSet.remove(o);
                        break;
                    }
                    if (matches) continue;
                    return null;
                }
            }
            return objectSet.size() == 0 ? matcher : null;
        }
        for (int yo = 0; yo <= inv.func_174923_h() - this.height; ++yo) {
            for (int xo = 0; xo <= inv.func_174922_i() - this.width; ++xo) {
                int y;
                int i;
                int x;
                int iIdx;
                IngredientMatcher matcher = new IngredientMatcher(this);
                boolean matches = false;
                for (iIdx = 0; iIdx < this.input.size() && (matches = matcher.add(inv.func_70463_b(x = (i = this.shapedOrdering != null ? this.shapedOrdering[iIdx] : iIdx) % this.width + xo, y = i / this.width + yo), (Ingredient)this.input.get(i))); ++iIdx) {
                }
                if (!matches && this.mirrored) {
                    matcher = new IngredientMatcher(this);
                    matches = false;
                    for (iIdx = 0; iIdx < this.input.size() && (matches = matcher.add(inv.func_70463_b(x = this.width - 1 - (i = this.shapedOrdering != null ? this.shapedOrdering[iIdx] : iIdx) % this.width + xo, y = i / this.width + yo), (Ingredient)this.input.get(i))); ++iIdx) {
                    }
                }
                if (!matches) continue;
                return matcher;
            }
        }
        return null;
    }

    public boolean func_77569_a(InventoryCrafting inv, @Nullable World worldIn) {
        return this.matchedOrNull(inv) != null;
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        IngredientMatcher matcher = this.matchedOrNull(inv);
        if (matcher != null) {
            return matcher.apply(this.output.getCraftingResult(this, matcher, inv));
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int i, int i1) {
        return this.shapeless ? i * i1 >= this.input.size() : this.width >= i && this.height >= i1;
    }

    public ItemStack func_77571_b() {
        return this.output.getDefaultOutput();
    }

    @Override
    public Ingredient getIngredient(char c) {
        return (Ingredient)this.charToIngredient.get(c);
    }

    public static class Factory
    implements IRecipeFactory {
        protected String getType(JsonContext context, JsonObject json) {
            return JsonUtils.func_151200_h((JsonObject)json, (String)"type");
        }

        protected Ingredient parseIngredient(JsonElement json, JsonContext context) {
            return CraftingHelper.getIngredient((JsonElement)json, (JsonContext)context);
        }

        protected void parseInputShapeless(RecipeCharset recipe, JsonContext context, JsonObject json) {
            JsonArray array = JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            recipe.input = NonNullList.func_191196_a();
            for (int i = 0; i < array.size(); ++i) {
                recipe.input.add((Object)this.parseIngredient(array.get(i), context));
            }
            recipe.width = recipe.input.size();
            recipe.height = 1;
        }

        protected void parseInputShaped(RecipeCharset recipe, JsonContext context, JsonObject json) {
            recipe.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)false);
            ArrayList<String> shape = new ArrayList<String>();
            JsonArray pattern = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
            for (int idx = 0; idx < pattern.size(); ++idx) {
                String s = pattern.get(idx).getAsString();
                shape.add(s);
                recipe.width = Math.max(recipe.width, s.length());
            }
            recipe.height = pattern.size();
            recipe.charToIngredient.put(' ', (Object)Ingredient.field_193370_a);
            TObjectCharHashMap ingredientToChar = new TObjectCharHashMap();
            JsonObject key = JsonUtils.func_152754_s((JsonObject)json, (String)"key");
            for (Map.Entry entry : key.entrySet()) {
                if (((String)entry.getKey()).length() > 1) {
                    throw new RuntimeException("Invalid recipe key: '" + (String)entry.getKey() + "'!");
                }
                char c = ((String)entry.getKey()).charAt(0);
                recipe.charToIngredient.put(c, (Object)this.parseIngredient((JsonElement)entry.getValue(), context));
                ingredientToChar.put(recipe.charToIngredient.get(c), c);
            }
            recipe.shapedOrdering = new int[recipe.width * recipe.height];
            recipe.input = NonNullList.func_191196_a();
            for (int y = 0; y < recipe.height; ++y) {
                String s = (String)shape.get(y);
                for (int x = 0; x < recipe.width; ++x) {
                    if (x < s.length()) {
                        Ingredient i = (Ingredient)recipe.charToIngredient.get(s.charAt(x));
                        if (i == null) {
                            throw new RuntimeException("IngredientMaterial not found: '" + s.charAt(x) + "'!");
                        }
                        recipe.input.add((Object)i);
                        continue;
                    }
                    recipe.input.add((Object)Ingredient.field_193370_a);
                }
            }
            HashSet<Ingredient> addedIngredients = new HashSet<Ingredient>();
            TIntHashSet addedPositions = new TIntHashSet();
            int idx = 0;
            while (idx < recipe.shapedOrdering.length) {
                int prevIdx = idx;
                for (int i = 0; i < recipe.input.size(); ++i) {
                    TCharSet deps;
                    if (addedPositions.contains(i)) continue;
                    Ingredient ingredient = (Ingredient)recipe.input.get(i);
                    TCharSet tCharSet = deps = ingredient instanceof IngredientCharset ? ((IngredientCharset)ingredient).getDependencies() : null;
                    if (deps != null && deps.size() > 0) {
                        boolean match = true;
                        TCharIterator it = deps.iterator();
                        while (it.hasNext()) {
                            if (addedIngredients.contains(recipe.charToIngredient.get(it.next()))) continue;
                            match = false;
                            break;
                        }
                        if (!match) continue;
                    }
                    if (!addedIngredients.contains(ingredient) && ingredient instanceof IngredientCharset) {
                        for (Ingredient ing : addedIngredients) {
                            ((IngredientCharset)ingredient).addDependency(ingredientToChar.get((Object)ing), ing);
                        }
                    }
                    recipe.shapedOrdering[idx++] = i;
                    addedIngredients.add(ingredient);
                    addedPositions.add(i);
                }
                if (prevIdx != idx) continue;
                throw new RuntimeException("Cyclic dependency detected!");
            }
        }

        public IRecipe parse(JsonContext context, JsonObject json) {
            RecipeCharset recipe;
            String type = this.getType(context, json);
            if (type.endsWith("shapeless")) {
                recipe = new RecipeCharset(context, json);
                this.parseInputShapeless(recipe, context, json);
            } else if (type.endsWith("shaped")) {
                recipe = new Shaped(context, json);
                this.parseInputShaped(recipe, context, json);
            } else {
                throw new RuntimeException("Unknown type: " + type);
            }
            recipe.output = OutputSupplier.createOutputSupplier(context, JsonUtils.func_152754_s((JsonObject)json, (String)"result"));
            return recipe;
        }
    }

    public static enum Type {
        SHAPED,
        SHAPELESS;

    }

    public static class Shaped
    extends RecipeCharset
    implements IShapedRecipe {
        public Shaped(JsonContext context, JsonObject object) {
            super(context, object);
        }

        public Shaped(String group) {
            super(group);
        }

        public Shaped(String group, boolean hidden) {
            super(group, hidden);
        }

        public int getRecipeWidth() {
            return this.getWidth();
        }

        public int getRecipeHeight() {
            return this.getHeight();
        }
    }
}

