/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render.model;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import pl.asie.charset.lib.render.model.SimpleBakedModel;

public final class ModelTransformer {
    private ModelTransformer() {
    }

    public static IBakedModel transform(IBakedModel model, IBlockState state, long rand, IVertexTransformer transformer) {
        return ModelTransformer.transform(model, state, rand, transformer, null);
    }

    public static IBakedModel transform(IBakedModel model, IBlockState state, long rand, IVertexTransformer transformer, @Nullable Function<BakedQuad, VertexFormat> format) {
        SimpleBakedModel out = new SimpleBakedModel(model);
        for (int i = 0; i <= 6; ++i) {
            EnumFacing side = i == 6 ? null : EnumFacing.func_82600_a((int)i);
            for (BakedQuad quad : model.func_188616_a(state, side, rand)) {
                out.addQuad(side, ModelTransformer.transform(quad, transformer, format));
            }
        }
        return out;
    }

    public static BakedQuad transform(BakedQuad quad, IVertexTransformer transformer) {
        return ModelTransformer.transform(quad, transformer, null);
    }

    public static BakedQuad transform(BakedQuad quad, IVertexTransformer transformer, @Nullable Function<BakedQuad, VertexFormat> format2) {
        VertexFormat format = format2 != null ? format2.apply(quad) : quad.getFormat();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        LightUtil.putBakedQuad((IVertexConsumer)new VertexTransformerWrapper((IVertexConsumer)builder, quad, transformer), (BakedQuad)quad);
        return builder.build();
    }

    public class Tinter
    implements IVertexTransformer {
        private float[] color = new float[4];

        public Tinter(int color) {
            this.color[0] = (float)(color >> 24 & 0xFF) / 255.0f;
            this.color[1] = (float)(color >> 16 & 0xFF) / 255.0f;
            this.color[2] = (float)(color >> 8 & 0xFF) / 255.0f;
            this.color[3] = (float)(color >> 0 & 0xFF) / 255.0f;
        }

        @Override
        public float[] transform(BakedQuad quad, VertexFormatElement element, float ... data) {
            if (element.func_177375_c() == VertexFormatElement.EnumUsage.COLOR) {
                return new float[]{data[0] * this.color[0], data[1] * this.color[1], data[2] * this.color[2], data[3] * this.color[3]};
            }
            return data;
        }
    }

    public static interface IVertexTransformer {
        public float[] transform(BakedQuad var1, VertexFormatElement var2, float ... var3);
    }

    private static final class VertexTransformerWrapper
    implements IVertexConsumer {
        private final IVertexConsumer parent;
        private final BakedQuad parentQuad;
        private final VertexFormat format;
        private final IVertexTransformer transformer;

        public VertexTransformerWrapper(IVertexConsumer parent, BakedQuad parentQuad, IVertexTransformer transformer) {
            this.parent = parent;
            this.parentQuad = parentQuad;
            this.format = parent.getVertexFormat();
            this.transformer = transformer;
        }

        public VertexFormat getVertexFormat() {
            return this.format;
        }

        public void setQuadTint(int tint) {
            this.parent.setQuadTint(tint);
        }

        public void setQuadOrientation(EnumFacing orientation) {
            this.parent.setQuadOrientation(orientation);
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            this.parent.setApplyDiffuseLighting(diffuse);
        }

        public void setTexture(TextureAtlasSprite texture) {
            this.parent.setTexture(texture);
        }

        public void put(int elementId, float ... data) {
            VertexFormatElement element = this.format.func_177348_c(elementId);
            this.parent.put(elementId, this.transformer.transform(this.parentQuad, element, data));
        }
    }
}

