/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import com.google.common.collect.Multimap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.lib.CharsetLib;
import pl.asie.charset.lib.utils.PlayerUtils;

public final class ItemUtils {
    private ItemUtils() {
    }

    public static ItemStack firstNonEmpty(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static int hashCode(ItemStack stack, boolean includeNBT) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int hash = stack.func_190916_E();
        hash = 31 * hash + Item.func_150891_b((Item)stack.func_77973_b());
        hash = 7 * hash + stack.func_77952_i();
        if (includeNBT) {
            hash = 7 * hash + (stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0);
        }
        return hash;
    }

    public static boolean isOreType(ItemStack stack, String ore) {
        int oreId = OreDictionary.getOreID((String)ore);
        for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (oreId != i) continue;
            return true;
        }
        return false;
    }

    public static double getAttributeValue(EntityEquipmentSlot slot, ItemStack is, IAttribute attr) {
        Multimap attrs = is.func_77973_b().getAttributeModifiers(slot, is);
        if (attrs != null) {
            AttributeMap map = new AttributeMap();
            map.func_111147_b(attrs);
            ModifiableAttributeInstance instance = map.func_111151_a(attr);
            if (instance != null) {
                return instance.func_111126_e();
            }
        }
        return 0.0;
    }

    public static NBTTagCompound getTagCompound(ItemStack stack, boolean create) {
        if (create && !stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static void writeToNBT(ItemStack stack, NBTTagCompound compound, String key) {
        NBTTagCompound compound1 = new NBTTagCompound();
        stack.func_77955_b(compound1);
        compound.func_74782_a(key, (NBTBase)compound1);
    }

    public static IBlockState getBlockState(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            int m = stack.func_77960_j();
            if (m >= 0 && m < 16) {
                try {
                    return ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                }
                catch (Exception e) {
                    return ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176223_P();
                }
            }
            return ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176223_P();
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return block.func_176223_P();
    }

    public static boolean canMerge(ItemStack source, ItemStack target) {
        return ItemUtils.equals(source, target, false, true, true);
    }

    public static boolean equalsMeta(ItemStack source, ItemStack target) {
        if (source.func_190926_b()) {
            return target.func_190926_b();
        }
        return ItemUtils.equals(source, target, false, !source.func_77973_b().func_77645_m(), false);
    }

    public static boolean equals(ItemStack source, ItemStack target, boolean matchStackSize, boolean matchDamage, boolean matchNBT) {
        return ItemUtils.equals(source, target, matchStackSize, matchDamage, matchNBT, matchNBT);
    }

    public static boolean equals(ItemStack source, ItemStack target, boolean matchStackSize, boolean matchDamage, boolean matchNBT, boolean matchCaps) {
        if (source == target) {
            return true;
        }
        if (source.func_190926_b()) {
            return target.func_190926_b();
        }
        if (source.func_77973_b() != target.func_77973_b()) {
            return false;
        }
        if (matchStackSize && source.func_190916_E() != target.func_190916_E()) {
            return false;
        }
        if (matchDamage && source.func_77952_i() != target.func_77952_i()) {
            return false;
        }
        if (matchNBT) {
            if (source.func_77942_o() != target.func_77942_o()) {
                return false;
            }
            if (source.func_77942_o() && !source.func_77978_p().equals((Object)target.func_77978_p())) {
                return false;
            }
        }
        return !matchCaps || source.areCapsCompatible(target);
    }

    public static EntityItem giveOrSpawnItemEntity(EntityPlayer player, World world, Vec3d loc, ItemStack stack, float mXm, float mYm, float mZm, float randomness) {
        if (!CharsetLib.alwaysDropDroppablesGivenToPlayer && player.field_71071_by != null && !PlayerUtils.isFake(player) && player.field_71071_by.func_70441_a(stack)) {
            return null;
        }
        return ItemUtils.spawnItemEntity(world, loc, stack, mXm, mYm, mZm, randomness);
    }

    public static EntityItem spawnItemEntity(World world, Vec3d loc, ItemStack stack, float mXm, float mYm, float mZm, float randomness) {
        EntityItem entityItem = new EntityItem(world, loc.field_72450_a, loc.field_72448_b, loc.field_72449_c, stack);
        entityItem.func_174869_p();
        if (randomness <= 0.0f) {
            entityItem.field_70159_w = mXm;
            entityItem.field_70181_x = mYm;
            entityItem.field_70179_y = mZm;
        } else {
            entityItem.field_70159_w = ((double)(1.0f - randomness) + (world.field_73012_v.nextDouble() - 0.5) * 2.0 * (double)randomness) * (double)mXm;
            entityItem.field_70181_x = ((double)(1.0f - randomness) + (world.field_73012_v.nextDouble() - 0.5) * 2.0 * (double)randomness) * (double)mYm;
            entityItem.field_70179_y = ((double)(1.0f - randomness) + (world.field_73012_v.nextDouble() - 0.5) * 2.0 * (double)randomness) * (double)mZm;
        }
        world.func_72838_d((Entity)entityItem);
        return entityItem;
    }
}

