/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import com.google.common.io.ByteArrayDataOutput;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.utils.Orientation;
import pl.asie.charset.lib.utils.SpaceUtils;

public class Quaternion {
    public double w;
    public double x;
    public double y;
    public double z;
    private static ThreadLocal<double[]> localStaticArray = new ThreadLocal<double[]>(){

        @Override
        protected double[] initialValue() {
            return new double[4];
        }
    };
    private static Quaternion[] quat_cache = new Quaternion[25];
    private Quaternion _vector_conversion_cache = null;

    public Quaternion() {
        this(1.0, 0.0, 0.0, 0.0);
    }

    public Quaternion(double w, double x, double y, double z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Quaternion(Quaternion orig) {
        this.w = orig.w;
        this.x = orig.x;
        this.y = orig.y;
        this.z = orig.z;
    }

    public Quaternion(double[] init) {
        this(init[0], init[1], init[2], init[3]);
        assert (init.length == 4);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quaternion) {
            Quaternion other = (Quaternion)obj;
            return this.w == other.w && this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public String toString() {
        String m = "";
        double mag = this.magnitude();
        if (mag != 1.0) {
            m = " MAG=" + mag;
        }
        return "Q<w=" + this.w + ", " + this.x + ", " + this.y + ", " + this.z + ">" + m;
    }

    public void writeToTag(NBTTagCompound tag, String prefix) {
        tag.func_74780_a(prefix + "w", this.w);
        tag.func_74780_a(prefix + "x", this.x);
        tag.func_74780_a(prefix + "y", this.y);
        tag.func_74780_a(prefix + "z", this.z);
    }

    public static Quaternion loadFromTag(NBTTagCompound tag, String prefix) {
        return new Quaternion(tag.func_74769_h(prefix + "w"), tag.func_74769_h(prefix + "x"), tag.func_74769_h(prefix + "y"), tag.func_74769_h(prefix + "z"));
    }

    public void write(ByteArrayDataOutput out) {
        double[] d = this.toStaticArray();
        for (int i = 0; i < d.length; ++i) {
            out.writeDouble(d[i]);
        }
    }

    public void write(ByteBuf out) {
        double[] d = this.toStaticArray();
        for (int i = 0; i < d.length; ++i) {
            out.writeDouble(d[i]);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        double[] d = this.toStaticArray();
        for (int i = 0; i < d.length; ++i) {
            out.writeDouble(d[i]);
        }
    }

    public static Quaternion read(DataInput in) throws IOException {
        double[] d = localStaticArray.get();
        for (int i = 0; i < d.length; ++i) {
            d[i] = in.readDouble();
        }
        return new Quaternion(d);
    }

    public static Quaternion read(ByteBuf in) throws IOException {
        double[] d = localStaticArray.get();
        for (int i = 0; i < d.length; ++i) {
            d[i] = in.readDouble();
        }
        return new Quaternion(d);
    }

    public double[] fillArray(double[] out) {
        out[0] = this.w;
        out[1] = this.x;
        out[2] = this.y;
        out[3] = this.z;
        return out;
    }

    public double[] toArray() {
        return this.fillArray(new double[4]);
    }

    public double[] toStaticArray() {
        return this.fillArray(localStaticArray.get());
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public void update(double nw, double nx, double ny, double nz) {
        this.w = nw;
        this.x = nx;
        this.y = ny;
        this.z = nz;
    }

    public void update(Quaternion other) {
        this.update(other.w, other.x, other.y, other.z);
    }

    public void update(EnumFacing dir) {
        this.update(this.w, dir.func_176730_m().func_177958_n(), dir.func_176730_m().func_177956_o(), dir.func_176730_m().func_177952_p());
    }

    public void update(Vec3d v) {
        this.update(0.0, v.field_72450_a, v.field_72448_b, v.field_72449_c);
    }

    public Vec3d toVector() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public Vec3d toRotationVector() {
        Vec3d rotVec = this.toVector().func_72432_b();
        return SpaceUtils.scale(rotVec, this.getAngleRadians());
    }

    public double getAngleRadians() {
        return 2.0 * Math.acos(this.w);
    }

    public Quaternion incrNormalize() {
        double normSquared = this.magnitudeSquared();
        if (normSquared == 1.0 || normSquared == 0.0) {
            return this;
        }
        double norm = Math.sqrt(normSquared);
        this.w /= norm;
        this.x /= norm;
        this.y /= norm;
        this.z /= norm;
        return this;
    }

    @Deprecated
    public static Quaternion getRotationQuaternion(Orientation orient) {
        return Quaternion.getRotationQuaternionRadians(Math.toRadians(orient.getRotation() * 90), orient.facing);
    }

    public static Quaternion getRotationQuaternionRadians(double angle, Vec3d axis) {
        double halfAngle = angle / 2.0;
        double sin = Math.sin(halfAngle);
        return new Quaternion(Math.cos(halfAngle), axis.field_72450_a * sin, axis.field_72448_b * sin, axis.field_72449_c * sin);
    }

    public static Quaternion getRotationQuaternionRadians(double angle, EnumFacing axis) {
        double halfAngle = angle / 2.0;
        double sin = Math.sin(halfAngle);
        return new Quaternion(Math.cos(halfAngle), (double)axis.func_176730_m().func_177958_n() * sin, (double)axis.func_176730_m().func_177956_o() * sin, (double)axis.func_176730_m().func_177952_p() * sin);
    }

    public static Quaternion getRotationQuaternionRadians(double angle, double ax, double ay, double az) {
        double halfAngle = angle / 2.0;
        double sin = Math.sin(halfAngle);
        return new Quaternion(Math.cos(halfAngle), ax * sin, ay * sin, az * sin);
    }

    public static Quaternion fromOrientation(Orientation orient) {
        Quaternion q1;
        int ord = orient.ordinal();
        if (quat_cache[ord] != null) {
            return quat_cache[ord];
        }
        if (orient == null) {
            Quaternion.quat_cache[ord] = new Quaternion();
            return Quaternion.quat_cache[ord];
        }
        double quart = Math.toRadians(90.0);
        int rotation = orient.getRotation();
        switch (orient.facing) {
            case UP: {
                q1 = Quaternion.getRotationQuaternionRadians(0.0 * quart, EnumFacing.WEST);
                rotation = 5 - rotation;
                break;
            }
            case DOWN: {
                q1 = Quaternion.getRotationQuaternionRadians(2.0 * quart, EnumFacing.WEST);
                rotation = 3 - rotation;
                break;
            }
            case NORTH: {
                q1 = Quaternion.getRotationQuaternionRadians(1.0 * quart, EnumFacing.WEST);
                rotation = 5 - rotation;
                break;
            }
            case SOUTH: {
                q1 = Quaternion.getRotationQuaternionRadians(-1.0 * quart, EnumFacing.WEST);
                rotation = 3 - rotation;
                break;
            }
            case EAST: {
                q1 = Quaternion.getRotationQuaternionRadians(1.0 * quart, EnumFacing.NORTH);
                rotation += Math.abs(orient.top.func_176730_m().func_177952_p()) * 2;
                break;
            }
            case WEST: {
                q1 = Quaternion.getRotationQuaternionRadians(-1.0 * quart, EnumFacing.NORTH);
                rotation += Math.abs(orient.top.func_176730_m().func_177956_o()) * 2;
                break;
            }
            default: {
                Quaternion.quat_cache[ord] = new Quaternion();
                return Quaternion.quat_cache[ord];
            }
        }
        Quaternion q2 = Quaternion.getRotationQuaternionRadians((double)rotation * quart, orient.facing);
        q2.incrMultiply(q1);
        Quaternion.quat_cache[ord] = q2;
        return Quaternion.quat_cache[ord];
    }

    @SideOnly(value=Side.CLIENT)
    public void glRotate() {
        double halfAngle = Math.acos(this.w);
        double sin = Math.sin(halfAngle);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(halfAngle * 2.0)), (float)((float)(this.x / sin)), (float)((float)(this.y / sin)), (float)((float)(this.z / sin)));
    }

    public double dotProduct(Quaternion other) {
        return this.w * other.w + this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public void incrLerp(Quaternion other, double t) {
        other.incrAdd(this, -1.0);
        other.incrScale(t);
        this.incrAdd(other);
        this.incrNormalize();
    }

    public Quaternion lerp(Quaternion other, double t) {
        Quaternion ret = new Quaternion(this);
        ret.incrLerp(other, t);
        return ret;
    }

    public void incrShortFor(Quaternion other) {
        double cosom = this.dotProduct(other);
        if (cosom < 0.0) {
            this.incrScale(-1.0);
        }
    }

    public void incrLongFor(Quaternion other) {
        double cosom = this.dotProduct(other);
        if (cosom > 0.0) {
            this.incrScale(-1.0);
        }
    }

    public Quaternion slerp(Quaternion other, double t) {
        double sc2;
        double sc1;
        if (t == 1.0) {
            return new Quaternion(other);
        }
        if (t == 0.0) {
            return new Quaternion(this);
        }
        double cosom = this.dotProduct(other);
        if (1.0 - cosom > (double)1.0E-4f) {
            double omega = Math.acos(cosom);
            double sinom = Math.sin(omega);
            sc1 = Math.sin((1.0 - t) * omega) / sinom;
            sc2 = Math.sin(t * omega) / sinom;
        } else {
            sc1 = 1.0 - t;
            sc2 = t;
        }
        return new Quaternion(sc1 * this.w + sc2 * other.w, sc1 * this.x + sc2 * other.x, sc1 * this.y + sc2 * other.y, sc1 * this.z + sc2 * other.z);
    }

    public Quaternion shortSlerp(Quaternion other, double t) {
        double sc2;
        double sc1;
        boolean rev;
        double cosom = this.dotProduct(other);
        boolean bl = rev = cosom < 0.0;
        if (rev) {
            cosom = -cosom;
            other.incrScale(-1.0);
        }
        if (1.0 - cosom > (double)1.0E-4f) {
            double omega = Math.acos(cosom);
            double sinom = Math.sin(omega);
            sc1 = Math.sin((1.0 - t) * omega) / sinom;
            sc2 = Math.sin(t * omega) / sinom;
        } else {
            sc1 = 1.0 - t;
            sc2 = t;
        }
        Quaternion ret = new Quaternion(sc1 * this.w + sc2 * other.w, sc1 * this.x + sc2 * other.x, sc1 * this.y + sc2 * other.y, sc1 * this.z + sc2 * other.z);
        if (rev) {
            other.incrScale(-1.0);
        }
        return ret;
    }

    public double getAngleBetween(Quaternion other) {
        double dot = this.dotProduct(other);
        dot = Math.max(-1.0, Math.min(1.0, dot));
        return Math.acos(dot);
    }

    public double magnitude() {
        return Math.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double magnitudeSquared() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double incrDistance(Quaternion other) {
        this.incrAdd(other);
        return this.magnitude();
    }

    public Quaternion incrConjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Quaternion incrAdd(Quaternion other) {
        this.w += other.w;
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        return this;
    }

    public Quaternion incrAdd(Quaternion other, double scale) {
        this.w += other.w * scale;
        this.x += other.x * scale;
        this.y += other.y * scale;
        this.z += other.z * scale;
        return this;
    }

    public Quaternion incrMultiply(Quaternion other) {
        double nw = this.w * other.w - this.x * other.x - this.y * other.y - this.z * other.z;
        double nx = this.w * other.x + this.x * other.w + this.y * other.z - this.z * other.y;
        double ny = this.w * other.y - this.x * other.z + this.y * other.w + this.z * other.x;
        double nz = this.w * other.z + this.x * other.y - this.y * other.x + this.z * other.w;
        this.update(nw, nx, ny, nz);
        return this;
    }

    public void incrToOtherMultiply(Quaternion other) {
        double nw = this.w * other.w - this.x * other.x - this.y * other.y - this.z * other.z;
        double nx = this.w * other.x + this.x * other.w + this.y * other.z - this.z * other.y;
        double ny = this.w * other.y - this.x * other.z + this.y * other.w + this.z * other.x;
        double nz = this.w * other.z + this.x * other.y - this.y * other.x + this.z * other.w;
        other.update(nw, nx, ny, nz);
    }

    public void incrScale(double scaler) {
        this.w *= scaler;
        this.x *= scaler;
        this.y *= scaler;
        this.z *= scaler;
    }

    public void incrUnit() {
        this.incrScale(1.0 / this.magnitude());
    }

    public void incrReciprocal() {
        double m = this.magnitude();
        this.incrConjugate();
        this.incrScale(1.0 / (m * m));
    }

    public void incrCross(Quaternion other) {
        double X = this.y * other.z - this.z * other.y;
        double Y = this.z * other.x - this.x * other.z;
        double Z = this.x * other.y - this.y * other.x;
        this.x = X;
        this.y = Y;
        this.z = Z;
    }

    public Quaternion cross(Quaternion other) {
        Quaternion m = new Quaternion(this);
        m.incrCross(other);
        return m;
    }

    public void incrRotateBy(Quaternion rotation) {
        rotation.incrToOtherMultiply(this);
        rotation.incrConjugate();
        this.incrMultiply(rotation);
        rotation.incrConjugate();
    }

    public Vec3d applyRotation(Vec3d p) {
        if (this.isZero()) {
            return p;
        }
        if (this._vector_conversion_cache == null) {
            this._vector_conversion_cache = new Quaternion();
        }
        Quaternion point = this._vector_conversion_cache;
        point.update(p);
        this.incrToOtherMultiply(point);
        this.incrConjugate();
        point.incrMultiply(this);
        this.incrConjugate();
        return point.toVector();
    }

    public void applyReverseRotation(Vec3d p) {
        this.incrConjugate();
        this.applyRotation(p);
        this.incrConjugate();
    }

    public double distance(Quaternion other) {
        return this.add(other).magnitude();
    }

    public Quaternion conjugate() {
        Quaternion ret = new Quaternion(this);
        ret.incrConjugate();
        return ret;
    }

    public Quaternion add(Quaternion other) {
        Quaternion ret = new Quaternion(this);
        ret.incrAdd(other);
        return ret;
    }

    public Quaternion add(Quaternion other, double scale) {
        Quaternion ret = new Quaternion(this);
        ret.incrAdd(other, scale);
        return ret;
    }

    public Quaternion multiply(Quaternion other) {
        Quaternion a = new Quaternion(this);
        a.incrMultiply(other);
        return a;
    }

    public Quaternion scale(double scaler) {
        Quaternion a = new Quaternion(this);
        a.incrScale(scaler);
        return a;
    }

    public Quaternion unit() {
        Quaternion r = new Quaternion(this);
        r.incrUnit();
        return r;
    }

    public Quaternion reciprocal() {
        Quaternion r = new Quaternion(this);
        r.incrReciprocal();
        return r;
    }

    public Quaternion power(double alpha) {
        double norm = this.magnitude();
        double theta = Math.acos(this.w / norm);
        double qa = Math.pow(norm, alpha);
        double alphaTheta = alpha * theta;
        double W = qa * Math.cos(alpha * theta);
        double sat = Math.sin(alphaTheta);
        return new Quaternion(W, this.x * sat, this.y * sat, this.z * sat);
    }

    public boolean hasNaN() {
        return Double.isNaN(this.w) || Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public boolean hasInf() {
        return Double.isInfinite(this.w) || Double.isInfinite(this.x) || Double.isInfinite(this.y) || Double.isInfinite(this.z);
    }

    public Quaternion cleanAbnormalNumbers() {
        if (this.hasNaN() || this.hasInf()) {
            return new Quaternion();
        }
        return this;
    }

    public Quat4f toJavax() {
        return new Quat4f((float)this.x, (float)this.y, (float)this.z, (float)this.w);
    }

    public Quat4d toJavaxD() {
        return new Quat4d(this.x, this.y, this.z, this.w);
    }
}

