/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class RayTraceUtils {
    private RayTraceUtils() {
    }

    public static Vec3d getStart(EntityLivingBase player) {
        return new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
    }

    public static Vec3d getEnd(EntityLivingBase player) {
        double reachDistance = player instanceof EntityPlayerMP ? ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() : 5.0;
        Vec3d lookVec = player.func_70040_Z();
        return RayTraceUtils.getStart(player).func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
    }

    public static Result getCollision(World world, BlockPos pos, EntityLivingBase player, List<AxisAlignedBB> list) {
        Vec3d origin = RayTraceUtils.getStart(player);
        Vec3d direction = RayTraceUtils.getEnd(player);
        return RayTraceUtils.getCollision(world, pos, origin, direction, list);
    }

    public static RayTraceResult getCollision(World world, BlockPos pos, EntityLivingBase player, AxisAlignedBB aabb, int subHit) {
        Vec3d origin = RayTraceUtils.getStart(player);
        Vec3d direction = RayTraceUtils.getEnd(player);
        return RayTraceUtils.getCollision(pos, origin, direction, aabb, subHit);
    }

    public static Result getCollision(World world, BlockPos pos, Vec3d origin, Vec3d direction, List<AxisAlignedBB> list) {
        double minDistance = Double.POSITIVE_INFINITY;
        RayTraceResult hit = null;
        for (int i = 0; i < list.size(); ++i) {
            double d;
            RayTraceResult mop;
            if (list.get(i) == null || (mop = RayTraceUtils.getCollision(pos, origin, direction, list.get(i), i)) == null || !((d = mop.field_72307_f.func_72436_e(origin)) < minDistance)) continue;
            minDistance = d;
            hit = mop;
        }
        return new Result(hit, hit != null ? list.get(hit.subHit) : null);
    }

    public static RayTraceResult getCollision(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB aabb, int subHit) {
        start = start.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        end = end.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        Vec3d vecWest = start.func_72429_b(end, aabb.field_72340_a);
        Vec3d vecEast = start.func_72429_b(end, aabb.field_72336_d);
        Vec3d vecDown = start.func_72435_c(end, aabb.field_72338_b);
        Vec3d vecUp = start.func_72435_c(end, aabb.field_72337_e);
        Vec3d vecNorth = start.func_72434_d(end, aabb.field_72339_c);
        Vec3d vecSouth = start.func_72434_d(end, aabb.field_72334_f);
        if (!RayTraceUtils.isVecInsideYZBounds(aabb, vecWest)) {
            vecWest = null;
        }
        if (!RayTraceUtils.isVecInsideYZBounds(aabb, vecEast)) {
            vecEast = null;
        }
        if (!RayTraceUtils.isVecInsideXZBounds(aabb, vecDown)) {
            vecDown = null;
        }
        if (!RayTraceUtils.isVecInsideXZBounds(aabb, vecUp)) {
            vecUp = null;
        }
        if (!RayTraceUtils.isVecInsideXYBounds(aabb, vecNorth)) {
            vecNorth = null;
        }
        if (!RayTraceUtils.isVecInsideXYBounds(aabb, vecSouth)) {
            vecSouth = null;
        }
        Vec3d vecHit = null;
        if (vecWest != null && (vecHit == null || start.func_72436_e(vecWest) < start.func_72436_e(vecHit))) {
            vecHit = vecWest;
        }
        if (vecEast != null && (vecHit == null || start.func_72436_e(vecEast) < start.func_72436_e(vecHit))) {
            vecHit = vecEast;
        }
        if (vecDown != null && (vecHit == null || start.func_72436_e(vecDown) < start.func_72436_e(vecHit))) {
            vecHit = vecDown;
        }
        if (vecUp != null && (vecHit == null || start.func_72436_e(vecUp) < start.func_72436_e(vecHit))) {
            vecHit = vecUp;
        }
        if (vecNorth != null && (vecHit == null || start.func_72436_e(vecNorth) < start.func_72436_e(vecHit))) {
            vecHit = vecNorth;
        }
        if (vecSouth != null && (vecHit == null || start.func_72436_e(vecSouth) < start.func_72436_e(vecHit))) {
            vecHit = vecSouth;
        }
        if (vecHit == null) {
            return null;
        }
        EnumFacing sideHit = null;
        if (vecHit == vecWest) {
            sideHit = EnumFacing.WEST;
        }
        if (vecHit == vecEast) {
            sideHit = EnumFacing.EAST;
        }
        if (vecHit == vecDown) {
            sideHit = EnumFacing.DOWN;
        }
        if (vecHit == vecUp) {
            sideHit = EnumFacing.UP;
        }
        if (vecHit == vecNorth) {
            sideHit = EnumFacing.NORTH;
        }
        if (vecHit == vecSouth) {
            sideHit = EnumFacing.SOUTH;
        }
        RayTraceResult mop = new RayTraceResult(vecHit.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), sideHit, pos);
        mop.subHit = subHit;
        return mop;
    }

    private static boolean isVecInsideYZBounds(AxisAlignedBB aabb, Vec3d point) {
        return point == null ? false : point.field_72448_b >= aabb.field_72338_b && point.field_72448_b <= aabb.field_72337_e && point.field_72449_c >= aabb.field_72339_c && point.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXZBounds(AxisAlignedBB aabb, Vec3d point) {
        return point == null ? false : point.field_72450_a >= aabb.field_72340_a && point.field_72450_a <= aabb.field_72336_d && point.field_72449_c >= aabb.field_72339_c && point.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXYBounds(AxisAlignedBB aabb, Vec3d point) {
        return point == null ? false : point.field_72450_a >= aabb.field_72340_a && point.field_72450_a <= aabb.field_72336_d && point.field_72448_b >= aabb.field_72338_b && point.field_72448_b <= aabb.field_72337_e;
    }

    public static class Result {
        public final AxisAlignedBB box;
        public final RayTraceResult hit;

        public Result(RayTraceResult mop, AxisAlignedBB box) {
            this.hit = mop;
            this.box = box;
        }

        public boolean valid() {
            return this.hit != null && this.box != null;
        }
    }
}

