/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class RecipeUtils {
    private RecipeUtils() {
    }

    public static InventoryCrafting getCraftingInventory(int width, int height) {
        return new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return false;
            }
        }, width, height);
    }

    public static InventoryCrafting getCraftingInventory(int width, int height, ItemStack ... stacks) {
        InventoryCrafting crafting = RecipeUtils.getCraftingInventory(width, height);
        for (int i = 0; i < Math.min(width * height, stacks.length); ++i) {
            crafting.func_70299_a(i, stacks[i] == null || stacks[i].func_190926_b() ? ItemStack.field_190927_a : stacks[i].func_77946_l());
        }
        return crafting;
    }

    public static ItemStack getCraftingResult(World world, int width, int height, ItemStack ... stacks) {
        return RecipeUtils.getCraftingResult(world, RecipeUtils.getCraftingInventory(width, height, stacks));
    }

    public static ItemStack getCraftingResult(World world, InventoryCrafting crafting) {
        IRecipe recipe = RecipeUtils.findMatchingRecipe(crafting, world);
        if (recipe != null) {
            return recipe.func_77572_b(crafting);
        }
        return ItemStack.field_190927_a;
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting craftMatrix, World worldIn) {
        int width = craftMatrix.func_174922_i();
        int height = craftMatrix.func_174923_h();
        for (IRecipe irecipe : ForgeRegistries.RECIPES) {
            if (!irecipe.func_194133_a(width, height) || !irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe;
        }
        return null;
    }
}

