/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import java.util.Optional;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.multipart.MultipartRedstoneHelper;
import mcmultipart.api.slot.EnumEdgeSlot;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public final class RedstoneUtils {
    private RedstoneUtils() {
    }

    public static int getRedstonePower(World world, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block instanceof BlockRedstoneWire) {
            return (Integer)iblockstate.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
        }
        return block.shouldCheckWeakPower(iblockstate, (IBlockAccess)world, pos, facing) ? world.func_175676_y(pos) : iblockstate.func_185911_a((IBlockAccess)world, pos, facing);
    }

    public static boolean canConnectFace(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side, EnumFacing face) {
        Block block = state.func_177230_c();
        if ((block instanceof BlockRedstoneDiode || block instanceof BlockRedstoneWire || block instanceof BlockDaylightDetector || block instanceof BlockBasePressurePlate) && face != EnumFacing.DOWN) {
            return false;
        }
        if (block instanceof BlockLever && face != ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c().func_176734_d()) {
            return false;
        }
        if (block instanceof BlockButton && face != ((EnumFacing)state.func_177229_b((IProperty)BlockButton.field_176387_N)).func_176734_d()) {
            return false;
        }
        if (Loader.isModLoaded((String)"mcmultipart")) {
            return RedstoneUtils.canConnectRedstoneMultipart(state, block, world, pos, side, face);
        }
        return block.canConnectRedstone(state, world, pos, side);
    }

    @Optional.Method(modid="mcmultipart")
    private static boolean canConnectRedstoneMultipart(IBlockState state, Block block, IBlockAccess world, BlockPos pos, EnumFacing side, EnumFacing face) {
        Optional ui = MultipartHelper.getContainer((IBlockAccess)world, (BlockPos)pos);
        if (ui.isPresent()) {
            return MultipartRedstoneHelper.canConnectRedstone((IMultipartContainer)((IMultipartContainer)ui.get()), (EnumEdgeSlot)EnumEdgeSlot.fromFaces((EnumFacing)side, (EnumFacing)face), (EnumFacing)side);
        }
        return block.canConnectRedstone(state, world, pos, side);
    }
}

