/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.utils.UtilProxyCommon;

public final class RegistryUtils {
    private static final TIntObjectMap<String> takenEntityIds = new TIntObjectHashMap();

    private RegistryUtils() {
    }

    public static void registerModel(Item item, int meta, String name) {
        UtilProxyCommon.proxy.registerItemModel(item, meta, name);
    }

    public static void register(Class<? extends TileEntity> tileEntity, String name) {
        GameRegistry.registerTileEntity(tileEntity, (String)new ResourceLocation("charset", name).toString());
    }

    public static void register(Class<? extends Entity> entity, String name, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        int id;
        ConfigCategory category = ModCharset.configIds.getCategory("entity");
        if (category.containsKey(name)) {
            Property prop = category.get(name);
            id = prop.getInt();
        } else {
            id = 1;
            while (takenEntityIds.containsKey(id)) {
                ++id;
            }
            ModCharset.configIds.get("entity", name, id);
        }
        ResourceLocation nameLoc = new ResourceLocation("charset", name);
        EntityRegistry.registerModEntity((ResourceLocation)nameLoc, entity, (String)nameLoc.toString(), (int)id, (Object)ModCharset.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        takenEntityIds.put(id, (Object)name);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, T object, String name) {
        RegistryUtils.register(registry, object, name, ModCharset.CREATIVE_TAB);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, T object, String name, CreativeTabs tab) {
        if (object == null) {
            ModCharset.logger.error("Trying to register null object " + name + "! This usually signifies a worse crash in Charset.");
            return;
        }
        object.setRegistryName(new ResourceLocation("charset", name));
        registry.register(object);
        UtilProxyCommon.proxy.setCreativeTabIfNotPresent(object, tab);
    }

    public static void loadConfigIds(Configuration configIds) {
        ConfigCategory cat = configIds.getCategory("entity");
        for (Map.Entry e : cat.entrySet()) {
            if (!((Property)e.getValue()).isIntValue()) continue;
            takenEntityIds.put(((Property)e.getValue()).getInt(), e.getKey());
        }
    }
}

