/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.lib.wires.BlockWire;
import pl.asie.charset.lib.wires.ItemWire;
import pl.asie.charset.lib.wires.RecipeWireConversion;
import pl.asie.charset.lib.wires.RendererWire;
import pl.asie.charset.lib.wires.TileWire;
import pl.asie.charset.lib.wires.WireHighlightHandler;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.lib.wires.WireProvider;

@CharsetModule(name="lib.wires", description="Wire support module", dependencies={"mod:mcmultipart"}, profile=ModuleProfile.STABLE)
public class CharsetLibWires {
    @CharsetModule.Instance
    public static CharsetLibWires instance;
    public static BlockWire blockWire;
    public static ItemWire itemWire;
    @SideOnly(value=Side.CLIENT)
    private RendererWire rendererWire;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        blockWire = new BlockWire();
        itemWire = new ItemWire(blockWire);
        WireManager.REGISTRY = (ForgeRegistry)new RegistryBuilder().setName(new ResourceLocation("charset:wire")).setIDRange(1, 255).setType(WireProvider.class).create();
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (int i = 0; i < 510; ++i) {
            RegistryUtils.registerModel((Item)itemWire, i, "charset:wire");
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryUtils.register(event.getRegistry(), blockWire, "wire");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register(event.getRegistry(), itemWire, "wire");
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register(new RecipeWireConversion(false).setRegistryName("charset:wire_conversion_to"));
        event.getRegistry().register(new RecipeWireConversion(true).setRegistryName("charset:wire_conversion_from"));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (WireProvider provider : WireManager.REGISTRY) {
            provider.generateBoxes();
        }
        RegistryUtils.register(TileWire.class, "wire");
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        this.rendererWire = new RendererWire();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        WireManager.REGISTRY.unfreeze();
        for (WireProvider provider : WireManager.REGISTRY) {
            this.rendererWire.registerSheet(event.getMap(), provider);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPostBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:wire", "redstone=false"), (Object)this.rendererWire);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:wire", "redstone=true"), (Object)this.rendererWire);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:wire", "inventory"), (Object)this.rendererWire);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new WireHighlightHandler());
    }
}

