/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.lib.recipe.IngredientCharset;
import pl.asie.charset.lib.recipe.OutputSupplier;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.wires.CharsetLibWires;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.lib.wires.WireProvider;

public class RecipeWireConversion
extends RecipeCharset {
    private final int outputOffset;

    private static List<ItemStack> getMatchingStacks(int offset) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (WireProvider provider : WireManager.REGISTRY) {
            if (!provider.hasSidedWire() || !provider.hasFreestandingWire()) continue;
            stacks.add(new ItemStack((Item)CharsetLibWires.itemWire, 1, WireManager.REGISTRY.getID((IForgeRegistryEntry)provider) << 1 | offset));
        }
        return stacks;
    }

    public RecipeWireConversion(boolean freestanding) {
        super("charset:wire_convert", true);
        this.input = NonNullList.func_191196_a();
        this.input.add((Object)new IngredientWires(freestanding));
        this.output = OutputSupplier.createStackOutputSupplier(ItemStack.field_190927_a);
        this.width = 1;
        this.height = 1;
        this.outputOffset = freestanding ? 0 : 1;
    }

    public List<ItemStack> getAllRecipeOutputs() {
        return RecipeWireConversion.getMatchingStacks(this.outputOffset);
    }

    @Override
    public ItemStack func_77572_b(InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ItemStack newStack = stack.func_77946_l();
            newStack.func_77964_b(newStack.func_77952_i() ^ 1);
            return newStack;
        }
        return ItemStack.field_190927_a;
    }

    public static class IngredientWires
    extends IngredientCharset {
        private final int offset;

        protected IngredientWires(boolean freestanding) {
            super(0);
            this.offset = freestanding ? 1 : 0;
        }

        @Override
        public boolean mustIteratePermutations() {
            return true;
        }

        public ItemStack[] func_193365_a() {
            List stacks = RecipeWireConversion.getMatchingStacks(this.offset);
            return stacks.toArray(new ItemStack[stacks.size()]);
        }

        public boolean apply(@Nullable ItemStack p_apply_1_) {
            if (!p_apply_1_.func_190926_b() && p_apply_1_.func_77973_b() == CharsetLibWires.itemWire && (p_apply_1_.func_77960_j() & 1) == this.offset) {
                WireProvider provider = (WireProvider)WireManager.REGISTRY.getValue(p_apply_1_.func_77960_j() >> 1);
                return provider.hasFreestandingWire() && provider.hasSidedWire();
            }
            return false;
        }
    }
}

