/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.utils.RotationUtils;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireUtils;

public abstract class WireProvider
implements IForgeRegistryEntry<WireProvider> {
    private final AxisAlignedBB[] boxes = new AxisAlignedBB[43];
    private final AxisAlignedBB[] cornerBoxes = new AxisAlignedBB[24];
    private ResourceLocation name;

    protected final void generateBoxes() {
        float xMin = 0.5f - this.getWidth() / 2.0f;
        float xMax = 0.5f + this.getWidth() / 2.0f;
        float y = this.getHeight();
        for (int j = 0; j < 6; ++j) {
            EnumFacing f = EnumFacing.func_82600_a((int)j);
            EnumFacing[] faces = WireUtils.getConnectionsForRender(WireFace.get(f));
            for (int i = 0; i < faces.length; ++i) {
                if (i >= 2) {
                    if (faces[i].func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                        this.boxes[j * 5 + i + 1] = RotationUtils.rotateFace(new AxisAlignedBB(0.0, 0.0, (double)xMin, (double)xMin, (double)y, (double)xMax), f);
                        this.cornerBoxes[j * 4 + i] = RotationUtils.rotateFace(new AxisAlignedBB(0.0, 0.0, (double)xMin, (double)y, (double)y, (double)xMax), f);
                        continue;
                    }
                    this.boxes[j * 5 + i + 1] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMax, 0.0, (double)xMin, 1.0, (double)y, (double)xMax), f);
                    this.cornerBoxes[j * 4 + i] = RotationUtils.rotateFace(new AxisAlignedBB((double)(1.0f - y), 0.0, (double)xMin, 1.0, (double)y, (double)xMax), f);
                    continue;
                }
                if (faces[i].func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                    this.boxes[j * 5 + i + 1] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, 0.0, (double)xMax, (double)y, (double)xMin), f);
                    this.cornerBoxes[j * 4 + i] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, 0.0, (double)xMax, (double)y, (double)y), f);
                    continue;
                }
                this.boxes[j * 5 + i + 1] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, (double)xMax, (double)xMax, (double)y, 1.0), f);
                this.cornerBoxes[j * 4 + i] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, (double)(1.0f - y), (double)xMax, (double)y, 1.0), f);
            }
            this.boxes[j * 5 + 0] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, (double)xMin, (double)xMax, (double)y, (double)xMax), f);
            this.boxes[31 + j] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, (double)y, (double)xMin, (double)xMax, (double)xMin, (double)xMax), f);
            this.boxes[37 + j] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, (double)xMin, (double)xMax, (double)xMin, (double)xMax), f);
        }
        this.boxes[30] = new AxisAlignedBB((double)xMin, (double)xMin, (double)xMin, (double)xMax, (double)xMax, (double)xMax);
    }

    public abstract Wire create(IWireContainer var1, WireFace var2);

    public boolean canProvidePower() {
        return false;
    }

    public boolean canPlace(IBlockAccess access, BlockPos pos, WireFace face) {
        if (face == WireFace.CENTER) {
            return this.hasFreestandingWire();
        }
        return this.hasSidedWire() && access.isSideSolid(pos.func_177972_a(face.facing), face.facing.func_176734_d(), false);
    }

    public AxisAlignedBB getBox(WireFace location, int i) {
        return this.boxes[location.ordinal() * 5 + i];
    }

    public AxisAlignedBB getSelectionBox(WireFace location, int i) {
        return this.getBox(location, i > 0 && location == WireFace.CENTER ? i + 6 : i);
    }

    public AxisAlignedBB getCornerCollisionBox(WireFace location, EnumFacing facing) {
        EnumFacing[] facings = WireUtils.getConnectionsForRender(location);
        for (int i = 0; i < facings.length; ++i) {
            if (facing != facings[i]) continue;
            return this.getCornerBox(location, i);
        }
        return null;
    }

    public AxisAlignedBB getCornerBox(WireFace location, int i) {
        return this.cornerBoxes[location.ordinal() * 4 + i];
    }

    public abstract float getWidth();

    public abstract float getHeight();

    public abstract ResourceLocation getTexturePrefix();

    public boolean hasSidedWire() {
        return true;
    }

    public boolean hasFreestandingWire() {
        return !this.isFlat();
    }

    public boolean isFlat() {
        return false;
    }

    public WireProvider setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<WireProvider> getRegistryType() {
        return WireProvider.class;
    }
}

