/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartCapabilityHelper;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.EnumEdgeSlot;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.world.IMultipartBlockAccess;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.capability.CapabilityHelper;
import pl.asie.charset.lib.utils.OcclusionUtils;
import pl.asie.charset.lib.wires.TileWire;
import pl.asie.charset.lib.wires.Wire;

public final class WireUtils {
    private static final EnumFacing[][] CONNECTION_DIRS = new EnumFacing[][]{{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, {EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}};

    private WireUtils() {
    }

    public static EnumFacing[] getConnectionsForRender(WireFace face) {
        return CONNECTION_DIRS[face.ordinal()];
    }

    public static boolean hasCapability(Wire wire, BlockPos pos, Capability<?> capability, EnumFacing face, boolean ignoreWires) {
        Optional container;
        TileWire.isWireCheckingForCaps = ignoreWires;
        if (wire.getLocation() != WireFace.CENTER && (container = MultipartHelper.getContainer((IBlockAccess)wire.getContainer().world(), (BlockPos)pos)).isPresent()) {
            boolean result = MultipartCapabilityHelper.hasCapability((IMultipartContainer)((IMultipartContainer)container.get()), capability, (EnumEdgeSlot)EnumEdgeSlot.fromFaces((EnumFacing)wire.getLocation().facing, (EnumFacing)face), (EnumFacing)face);
            TileWire.isWireCheckingForCaps = false;
            return result;
        }
        TileEntity tile = wire.getContainer().world().func_175625_s(pos);
        boolean result = tile != null && tile.hasCapability(capability, face);
        TileWire.isWireCheckingForCaps = false;
        return result;
    }

    public static <T> T getCapability(Wire searcher, BlockPos pos, Capability<T> capability, EnumFacing face, boolean ignoreWires) {
        Optional container;
        TileWire.isWireCheckingForCaps = ignoreWires;
        if (searcher.getLocation() != WireFace.CENTER && (container = MultipartHelper.getContainer((IBlockAccess)searcher.getContainer().world(), (BlockPos)pos)).isPresent()) {
            Object result = MultipartCapabilityHelper.getCapability((IMultipartContainer)((IMultipartContainer)container.get()), capability, (EnumEdgeSlot)EnumEdgeSlot.fromFaces((EnumFacing)searcher.getLocation().facing, (EnumFacing)face), (EnumFacing)face);
            TileWire.isWireCheckingForCaps = false;
            return (T)result;
        }
        T result = CapabilityHelper.get((IBlockAccess)searcher.getContainer().world(), pos, capability, face, true, true, false);
        TileWire.isWireCheckingForCaps = false;
        return result;
    }

    public static boolean canConnectInternal(Wire wire, WireFace side) {
        if (side == wire.getLocation()) {
            return false;
        }
        Wire wire2 = WireUtils.getWire((IBlockAccess)wire.getContainer().world(), wire.getContainer().pos(), side);
        return wire2 != null && wire2.canConnectWire(wire);
    }

    public static boolean canConnectExternal(Wire wire, EnumFacing facing) {
        BlockPos pos2 = wire.getContainer().pos().func_177972_a(facing);
        Wire wire2 = WireUtils.getWire((IBlockAccess)wire.getContainer().world(), pos2, wire.getLocation());
        if (wire2 != null) {
            if (wire2.isOccluded(facing.func_176734_d())) {
                return false;
            }
            return wire2.canConnectWire(wire);
        }
        return wire.canConnectBlock(pos2, facing.func_176734_d());
    }

    public static boolean canConnectCorner(Wire wire, EnumFacing direction) {
        if (wire.getLocation() == WireFace.CENTER || wire.isCornerOccluded(direction)) {
            return false;
        }
        EnumFacing side = wire.getLocation().facing;
        BlockPos middlePos = wire.getContainer().pos().func_177972_a(direction);
        if (wire.getContainer().world().isSideSolid(middlePos, direction.func_176734_d()) || wire.getContainer().world().isSideSolid(middlePos, side.func_176734_d())) {
            return false;
        }
        AxisAlignedBB mask = wire.getFactory().getCornerCollisionBox(wire.getLocation(), direction.func_176734_d());
        if (OcclusionUtils.INSTANCE.intersects(Collections.singletonList(mask), (IBlockAccess)wire.getContainer().world(), middlePos)) {
            return false;
        }
        BlockPos cornerPos = middlePos.func_177972_a(side);
        Wire wire2 = WireUtils.getWire((IBlockAccess)wire.getContainer().world(), cornerPos, WireFace.get(direction.func_176734_d()));
        return wire2 != null && !wire2.isCornerOccluded(side.func_176734_d()) && wire2.canConnectWire(wire);
    }

    @Nullable
    public static Wire getWire(IBlockAccess access, BlockPos pos, WireFace face) {
        Optional containerOpt;
        IMultipartContainer container = null;
        if (access instanceof IMultipartBlockAccess) {
            access = ((IMultipartBlockAccess)access).getActualWorld();
        }
        if ((containerOpt = MultipartHelper.getContainer((IBlockAccess)access, (BlockPos)pos)).isPresent()) {
            container = (IMultipartContainer)containerOpt.get();
        }
        if (container != null) {
            Wire wire;
            Optional tile = container.getPartTile(WireUtils.toPartSlot(face));
            if (tile.isPresent() && ((IMultipartTile)tile.get()).getTileEntity() instanceof TileWire && (wire = ((TileWire)((IMultipartTile)tile.get()).getTileEntity()).wire) != null && wire.getLocation() == face) {
                return ((TileWire)((IMultipartTile)tile.get()).getTileEntity()).wire;
            }
            return null;
        }
        TileEntity tile = access.func_175625_s(pos);
        if (tile != null && tile instanceof TileWire && ((TileWire)tile).wire != null && ((TileWire)tile).wire.getLocation() == face) {
            return ((TileWire)tile).wire;
        }
        return null;
    }

    @Nullable
    public static Wire getAnyWire(IBlockAccess access, BlockPos pos) {
        if (access instanceof IMultipartBlockAccess) {
            TileWire tileWire = (TileWire)((IMultipartBlockAccess)access).getPartInfo().getTile().getTileEntity();
            return tileWire.wire;
        }
        return WireUtils.getAnyWire(access.func_175625_s(pos));
    }

    public static Collection<Wire> getAllWires(IBlockAccess access, BlockPos pos) {
        Optional containerOpt = MultipartHelper.getContainer((IBlockAccess)access, (BlockPos)pos);
        if (containerOpt.isPresent()) {
            IMultipartContainer container = (IMultipartContainer)containerOpt.get();
            ArrayList<Wire> wires = new ArrayList<Wire>();
            for (IPartInfo partInfo : container.getParts().values()) {
                if (!(partInfo.getTile() instanceof TileWire)) continue;
                wires.add(((TileWire)partInfo.getTile()).wire);
            }
            return wires;
        }
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TileWire) {
            return Collections.singleton(((TileWire)tile).wire);
        }
        return Collections.emptySet();
    }

    @Nullable
    public static Wire getAnyWire(TileEntity tile) {
        if (tile != null && tile instanceof TileWire) {
            return ((TileWire)tile).wire;
        }
        return null;
    }

    public static IPartSlot toPartSlot(WireFace face) {
        return face == WireFace.CENTER ? EnumCenterSlot.CENTER : EnumFaceSlot.fromFace((EnumFacing)face.facing);
    }
}

