/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.libresample4j;

import java.nio.FloatBuffer;
import pl.asie.charset.module.audio.libresample4j.FilterKit;
import pl.asie.charset.module.audio.libresample4j.SampleBuffers;

public class Resampler {
    protected static final int Npc = 4096;
    private final float[] Imp;
    private final float[] ImpD;
    private final float LpScl;
    private final int Nmult;
    private final int Nwing;
    private final double minFactor;
    private final double maxFactor;
    private final int XSize;
    private final float[] X;
    private int Xp;
    private int Xread;
    private final int Xoff;
    private final float[] Y;
    private int Yp;
    private double Time;

    public Resampler(Resampler other) {
        this.Imp = (float[])other.Imp.clone();
        this.ImpD = (float[])other.ImpD.clone();
        this.LpScl = other.LpScl;
        this.Nmult = other.Nmult;
        this.Nwing = other.Nwing;
        this.minFactor = other.minFactor;
        this.maxFactor = other.maxFactor;
        this.XSize = other.XSize;
        this.X = (float[])other.X.clone();
        this.Xp = other.Xp;
        this.Xread = other.Xread;
        this.Xoff = other.Xoff;
        this.Y = (float[])other.Y.clone();
        this.Yp = other.Yp;
        this.Time = other.Time;
    }

    public Resampler(boolean highQuality, double minFactor, double maxFactor) {
        int i;
        if (minFactor <= 0.0 || maxFactor <= 0.0) {
            throw new IllegalArgumentException("minFactor and maxFactor must be positive");
        }
        if (maxFactor < minFactor) {
            throw new IllegalArgumentException("minFactor must be <= maxFactor");
        }
        this.minFactor = minFactor;
        this.maxFactor = maxFactor;
        this.Nmult = highQuality ? 35 : 11;
        this.LpScl = 1.0f;
        this.Nwing = 4096 * (this.Nmult - 1) / 2;
        double Rolloff = 0.9;
        double Beta = 6.0;
        double[] Imp64 = new double[this.Nwing];
        FilterKit.lrsLpFilter(Imp64, this.Nwing, 0.5 * Rolloff, Beta, 4096);
        this.Imp = new float[this.Nwing];
        this.ImpD = new float[this.Nwing];
        for (i = 0; i < this.Nwing; ++i) {
            this.Imp[i] = (float)Imp64[i];
        }
        for (i = 0; i < this.Nwing - 1; ++i) {
            this.ImpD[i] = this.Imp[i + 1] - this.Imp[i];
        }
        this.ImpD[this.Nwing - 1] = -this.Imp[this.Nwing - 1];
        int Xoff_min = (int)((double)(this.Nmult + 1) / 2.0 * Math.max(1.0, 1.0 / minFactor) + 10.0);
        int Xoff_max = (int)((double)(this.Nmult + 1) / 2.0 * Math.max(1.0, 1.0 / maxFactor) + 10.0);
        this.Xoff = Math.max(Xoff_min, Xoff_max);
        this.XSize = Math.max(2 * this.Xoff + 10, 4096);
        this.X = new float[this.XSize + this.Xoff];
        this.Xp = this.Xoff;
        this.Xread = this.Xoff;
        int YSize = (int)((double)this.XSize * maxFactor + 2.0);
        this.Y = new float[YSize];
        this.Yp = 0;
        this.Time = this.Xoff;
    }

    public int getFilterWidth() {
        return this.Xoff;
    }

    public boolean process(double factor, SampleBuffers buffers, boolean lastBatch) {
        int len;
        if (factor < this.minFactor || factor > this.maxFactor) {
            throw new IllegalArgumentException("factor " + factor + " is not between minFactor=" + this.minFactor + " and maxFactor=" + this.maxFactor);
        }
        int outBufferLen = buffers.getOutputBufferLength();
        int inBufferLen = buffers.getInputBufferLength();
        float[] Imp = this.Imp;
        float[] ImpD = this.ImpD;
        float LpScl = this.LpScl;
        int Nwing = this.Nwing;
        boolean interpFilt = false;
        int inBufferUsed = 0;
        int outSampleCount = 0;
        if (this.Yp != 0 && outBufferLen - outSampleCount > 0) {
            len = Math.min(outBufferLen - outSampleCount, this.Yp);
            buffers.consumeOutput(this.Y, 0, len);
            outSampleCount += len;
            for (int i = 0; i < this.Yp - len; ++i) {
                this.Y[i] = this.Y[i + len];
            }
            this.Yp -= len;
        }
        if (this.Yp != 0) {
            return inBufferUsed == 0 && outSampleCount == 0;
        }
        if (factor < 1.0) {
            LpScl = (float)((double)LpScl * factor);
        }
        do {
            int i;
            int Nx;
            if ((len = this.XSize - this.Xread) >= inBufferLen - inBufferUsed) {
                len = inBufferLen - inBufferUsed;
            }
            buffers.produceInput(this.X, this.Xread, len);
            this.Xread += len;
            if (lastBatch && (inBufferUsed += len) == inBufferLen) {
                Nx = this.Xread - this.Xoff;
                for (int i2 = 0; i2 < this.Xoff; ++i2) {
                    this.X[this.Xread + i2] = 0.0f;
                }
            } else {
                Nx = this.Xread - 2 * this.Xoff;
            }
            if (Nx <= 0) break;
            int Nout = factor >= 1.0 ? this.lrsSrcUp(this.X, this.Y, factor, Nx, Nwing, LpScl, Imp, ImpD, interpFilt) : this.lrsSrcUD(this.X, this.Y, factor, Nx, Nwing, LpScl, Imp, ImpD, interpFilt);
            this.Time -= (double)Nx;
            this.Xp += Nx;
            int Ncreep = (int)this.Time - this.Xoff;
            if (Ncreep != 0) {
                this.Time -= (double)Ncreep;
                this.Xp += Ncreep;
            }
            int Nreuse = this.Xread - (this.Xp - this.Xoff);
            for (i = 0; i < Nreuse; ++i) {
                this.X[i] = this.X[i + (this.Xp - this.Xoff)];
            }
            this.Xread = Nreuse;
            this.Xp = this.Xoff;
            this.Yp = Nout;
            if (this.Yp == 0 || outBufferLen - outSampleCount <= 0) continue;
            len = Math.min(outBufferLen - outSampleCount, this.Yp);
            buffers.consumeOutput(this.Y, 0, len);
            outSampleCount += len;
            for (i = 0; i < this.Yp - len; ++i) {
                this.Y[i] = this.Y[i + len];
            }
            this.Yp -= len;
        } while (this.Yp == 0);
        return inBufferUsed == 0 && outSampleCount == 0;
    }

    public boolean process(double factor, final FloatBuffer inputBuffer, boolean lastBatch, final FloatBuffer outputBuffer) {
        SampleBuffers sampleBuffers = new SampleBuffers(){

            public int getInputBufferLength() {
                return inputBuffer.remaining();
            }

            public int getOutputBufferLength() {
                return outputBuffer.remaining();
            }

            public void produceInput(float[] array, int offset, int length) {
                inputBuffer.get(array, offset, length);
            }

            public void consumeOutput(float[] array, int offset, int length) {
                outputBuffer.put(array, offset, length);
            }
        };
        return this.process(factor, sampleBuffers, lastBatch);
    }

    public Result process(double factor, float[] inBuffer, int inBufferOffset, int inBufferLen, boolean lastBatch, float[] outBuffer, int outBufferOffset, int outBufferLen) {
        FloatBuffer inputBuffer = FloatBuffer.wrap(inBuffer, inBufferOffset, inBufferLen);
        FloatBuffer outputBuffer = FloatBuffer.wrap(outBuffer, outBufferOffset, outBufferLen);
        this.process(factor, inputBuffer, lastBatch, outputBuffer);
        return new Result(inputBuffer.position() - inBufferOffset, outputBuffer.position() - outBufferOffset);
    }

    private int lrsSrcUp(float[] X, float[] Y, double factor, int Nx, int Nwing, float LpScl, float[] Imp, float[] ImpD, boolean Interp) {
        double CurrentTime;
        float[] Xp_array = X;
        float[] Yp_array = Y;
        int Yp_index = 0;
        double dt = 1.0 / factor;
        double endTime = CurrentTime + (double)Nx;
        for (CurrentTime = this.Time; CurrentTime < endTime; CurrentTime += dt) {
            double LeftPhase = CurrentTime - Math.floor(CurrentTime);
            double RightPhase = 1.0 - LeftPhase;
            int Xp_index = (int)CurrentTime;
            float v = FilterKit.lrsFilterUp(Imp, ImpD, Nwing, Interp, Xp_array, Xp_index++, LeftPhase, -1);
            v += FilterKit.lrsFilterUp(Imp, ImpD, Nwing, Interp, Xp_array, Xp_index, RightPhase, 1);
            Yp_array[Yp_index++] = v *= LpScl;
        }
        this.Time = CurrentTime;
        return Yp_index;
    }

    private int lrsSrcUD(float[] X, float[] Y, double factor, int Nx, int Nwing, float LpScl, float[] Imp, float[] ImpD, boolean Interp) {
        double CurrentTime;
        float[] Xp_array = X;
        float[] Yp_array = Y;
        int Yp_index = 0;
        double dt = 1.0 / factor;
        double dh = Math.min(4096.0, factor * 4096.0);
        double endTime = CurrentTime + (double)Nx;
        for (CurrentTime = this.Time; CurrentTime < endTime; CurrentTime += dt) {
            double LeftPhase = CurrentTime - Math.floor(CurrentTime);
            double RightPhase = 1.0 - LeftPhase;
            int Xp_index = (int)CurrentTime;
            float v = FilterKit.lrsFilterUD(Imp, ImpD, Nwing, Interp, Xp_array, Xp_index++, LeftPhase, -1, dh);
            v += FilterKit.lrsFilterUD(Imp, ImpD, Nwing, Interp, Xp_array, Xp_index, RightPhase, 1, dh);
            Yp_array[Yp_index++] = v *= LpScl;
        }
        this.Time = CurrentTime;
        return Yp_index;
    }

    public static class Result {
        public final int inputSamplesConsumed;
        public final int outputSamplesGenerated;

        public Result(int inputSamplesConsumed, int outputSamplesGenerated) {
            this.inputSamplesConsumed = inputSamplesConsumed;
            this.outputSamplesGenerated = outputSamplesGenerated;
        }
    }
}

