/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.note;

import java.lang.invoke.MethodHandle;
import java.util.function.Supplier;
import net.minecraft.block.BlockNote;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.IAudioReceiver;
import pl.asie.charset.api.audio.IAudioSource;
import pl.asie.charset.lib.audio.types.AudioDataGameSound;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.capability.CapabilityProviderFactory;
import pl.asie.charset.lib.capability.audio.DefaultAudioSource;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.utils.FunctionalUtils;
import pl.asie.charset.lib.utils.MethodHandleHelper;
import pl.asie.charset.module.audio.note.PacketNoteParticle;

@CharsetModule(name="audio.noteblock", description="Noteblock rework. WIP", profile=ModuleProfile.TESTING)
public class CharsetAudioNoteblock {
    private static final MethodHandle GET_INSTRUMENT = MethodHandleHelper.findMethod(BlockNote.class, "getInstrument", "func_185576_e", Integer.TYPE);
    private static final Supplier<CapabilityProviderFactory<IAudioSource>> PROVIDER = FunctionalUtils.lazySupplier(() -> new CapabilityProviderFactory<IAudioSource>(Capabilities.AUDIO_SOURCE));
    private static final ResourceLocation NOTE_SOURCE_KEY = new ResourceLocation("charsetaudio:noteSource");
    @CharsetModule.PacketRegistry
    public PacketRegistry packet;

    public static SoundEvent getSound(World world, BlockPos pos, int id) {
        if (GET_INSTRUMENT == null) {
            ModCharset.logger.error("BlockNote.getInstrument not found! This is bad!");
        }
        try {
            return GET_INSTRUMENT != null ? GET_INSTRUMENT.invokeExact((BlockNote)Blocks.field_150323_B, id) : SoundEvents.field_187682_dG;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return SoundEvents.field_187682_dG;
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.packet.registerPacket(1, PacketNoteParticle.class);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onNoteEvent(NoteBlockEvent.Play event) {
        World worldIn = event.getWorld();
        BlockPos pos = event.getPos();
        int param = event.getVanillaNoteId();
        SoundEvent sound = CharsetAudioNoteblock.getSound(event.getWorld(), event.getPos(), event.getInstrument().ordinal());
        float pitch = (float)Math.pow(2.0, (double)(param - 12) / 12.0);
        if (!worldIn.field_72995_K) {
            TileEntity note = worldIn.func_175625_s(pos);
            if (note != null && note.hasCapability(Capabilities.AUDIO_SOURCE, null)) {
                AudioDataGameSound dataSound = new AudioDataGameSound(((ResourceLocation)SoundEvent.field_187505_a.func_177774_c((Object)sound)).toString(), pitch);
                AudioPacket packet = new AudioPacket(dataSound, 1.0f);
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    TileEntity tile = event.getWorld().func_175625_s(pos.func_177972_a(facing));
                    if (tile == null || !tile.hasCapability(Capabilities.AUDIO_RECEIVER, facing.func_176734_d())) continue;
                    ((IAudioReceiver)tile.getCapability(Capabilities.AUDIO_RECEIVER, facing.func_176734_d())).receive(packet);
                }
                if (packet.getSinkCount() > 0) {
                    event.setCanceled(true);
                    packet.send();
                    return;
                }
            }
            if (event.getState().func_177230_c() == Blocks.field_150323_B) {
                event.setCanceled(true);
                worldIn.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 3.0f, pitch);
                this.packet.sendToAllAround((Packet)new PacketNoteParticle(note, param), note, 32.0);
            }
        }
    }

    @SubscribeEvent
    public void onAttach(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityNote) {
            event.addCapability(NOTE_SOURCE_KEY, PROVIDER.get().create(new DefaultAudioSource()));
        }
    }
}

