/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemStackHandler;
import pl.asie.charset.api.audio.AudioData;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.IAudioDataPCM;
import pl.asie.charset.api.audio.IAudioReceiver;
import pl.asie.charset.api.tape.IDataStorage;
import pl.asie.charset.lib.audio.AudioUtils;
import pl.asie.charset.lib.audio.codec.DFPWM;
import pl.asie.charset.lib.audio.types.AudioDataDFPWM;
import pl.asie.charset.lib.audio.types.AudioSinkBlock;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.module.audio.storage.CharsetAudioStorage;
import pl.asie.charset.module.audio.util.AudioResampler;

public class RecordPlayerState
implements ITickable,
IAudioReceiver,
INBTSerializable<NBTTagCompound> {
    private final World world;
    private final BlockPos pos;
    private final ItemStackHandler inventory;
    private State state = State.STOPPED;
    private State lastState;
    private Integer sourceId;
    private DFPWM recordDFPWM;
    private AudioPacket receivedPacket;
    private int receivedPacketPos;

    public RecordPlayerState(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.inventory = new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (stack.func_190926_b() || !stack.hasCapability(CharsetAudioStorage.DATA_STORAGE, null)) {
                    return ItemStack.field_190927_a;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void setState(State state) {
        this.lastState = this.state;
        this.state = state;
        if (state != State.RECORDING) {
            this.receivedPacket = null;
            this.recordDFPWM = null;
        }
    }

    private void applyNoise(byte[] data, float noiseThreshold) {
        Random rand = this.world.field_73012_v;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!(rand.nextFloat() <= noiseThreshold)) continue;
                if (rand.nextBoolean()) {
                    int n = i;
                    data[n] = (byte)(data[n] | 1 << j);
                    continue;
                }
                int n = i;
                data[n] = (byte)(data[n] & ~(1 << j));
            }
        }
    }

    public void func_73660_a() {
        if (this.state != State.STOPPED) {
            IDataStorage storage;
            if (this.sourceId == null) {
                this.sourceId = AudioUtils.start();
            }
            boolean found = false;
            ItemStack stack = this.inventory.getStackInSlot(0);
            if (!stack.func_190926_b() && stack.hasCapability(CharsetAudioStorage.DATA_STORAGE, null) && (storage = (IDataStorage)stack.getCapability(CharsetAudioStorage.DATA_STORAGE, null)) != null) {
                found = true;
                if (this.state == State.PLAYING) {
                    int sampleRate = 48000;
                    byte[] data = new byte[sampleRate / 160];
                    int len = storage.read(data, false);
                    AudioPacket packet = new AudioPacket(new AudioDataDFPWM(data, 50).setSourceId(this.sourceId), 1.0f);
                    boolean received = false;
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        TileEntity tile = this.world.func_175625_s(this.pos.func_177972_a(facing));
                        if (tile == null || !tile.hasCapability(Capabilities.AUDIO_RECEIVER, facing.func_176734_d())) continue;
                        received |= ((IAudioReceiver)tile.getCapability(Capabilities.AUDIO_RECEIVER, facing.func_176734_d())).receive(packet);
                    }
                    if (!received) {
                        new AudioSinkBlock(this.world, this.pos).receive(packet);
                    }
                    packet.send();
                    if (len < data.length) {
                        this.setState(State.STOPPED);
                    }
                } else if (this.state == State.RECORDING) {
                    AudioData data;
                    byte[] dataOut = new byte[300];
                    if (this.receivedPacket != null && (data = this.receivedPacket.getData()) instanceof IAudioDataPCM) {
                        int pos = this.receivedPacketPos;
                        IAudioDataPCM pcm = (IAudioDataPCM)((Object)data);
                        byte[] audioData = pcm.getSamplePCMData();
                        int perTick = audioData.length * 50 / data.getTime();
                        int len = perTick;
                        if (pos + len > audioData.length) {
                            len = audioData.length - pos;
                        }
                        if (len > 0) {
                            byte[] targetData = new byte[len];
                            System.arraycopy(audioData, pos, targetData, 0, len);
                            this.receivedPacketPos += len;
                            byte[] preEncodeOutput = AudioResampler.toSigned8(targetData, pcm.getSampleSize() * 8, 1, pcm.isSampleBigEndian(), pcm.isSampleSigned(), pcm.getSampleRate(), 48000, false);
                            if (preEncodeOutput != null) {
                                if (this.recordDFPWM == null) {
                                    this.recordDFPWM = new DFPWM();
                                }
                                this.recordDFPWM.compress(dataOut, preEncodeOutput, 0, 0, Math.min(dataOut.length, preEncodeOutput.length / 8));
                            }
                        } else {
                            this.receivedPacketPos = audioData.length;
                        }
                    }
                    storage.write(dataOut);
                }
            }
            if (!found) {
                this.setState(State.STOPPED);
            }
        }
        if (this.lastState != this.state && this.state == State.STOPPED && this.lastState == State.PLAYING && this.sourceId != null) {
            AudioUtils.stop(this.sourceId);
            this.sourceId = null;
        }
        this.lastState = this.state;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("st", (byte)this.state.ordinal());
        compound.func_74782_a("inv", (NBTBase)this.inventory.serializeNBT());
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.state = State.STOPPED;
        if (nbt != null) {
            byte stateId;
            if (nbt.func_150297_b("st", 99) && (stateId = nbt.func_74771_c("st")) >= 0 && stateId < State.values().length) {
                this.state = State.values()[stateId];
            }
            if (nbt.func_150297_b("inv", 10)) {
                this.inventory.deserializeNBT(nbt.func_74775_l("inv"));
            }
        }
    }

    public State getState() {
        return this.state;
    }

    public IDataStorage getStorage() {
        IDataStorage storage;
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!stack.func_190926_b() && stack.hasCapability(CharsetAudioStorage.DATA_STORAGE, null) && (storage = (IDataStorage)stack.getCapability(CharsetAudioStorage.DATA_STORAGE, null)) != null) {
            return storage;
        }
        return null;
    }

    @Override
    public boolean receive(AudioPacket packet) {
        if (this.state == State.RECORDING) {
            this.receivedPacket = packet;
            this.receivedPacketPos = 0;
            return true;
        }
        return false;
    }

    public static enum State {
        STOPPED,
        PLAYING,
        RECORDING;

    }
}

