/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import pl.asie.charset.api.laser.ILaserReceiver;
import pl.asie.charset.api.laser.LaserColor;
import pl.asie.charset.lib.capability.DummyCapabilityStorage;
import pl.asie.charset.lib.command.CommandCharset;
import pl.asie.charset.lib.handlers.ShiftScrollHandler;
import pl.asie.charset.lib.item.ItemBlockBase;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.module.laser.ProxyCommon;
import pl.asie.charset.module.laser.blocks.BlockCrystal;
import pl.asie.charset.module.laser.blocks.BlockJar;
import pl.asie.charset.module.laser.blocks.BlockPrism;
import pl.asie.charset.module.laser.blocks.BlockReflector;
import pl.asie.charset.module.laser.blocks.ItemBlockCrystal;
import pl.asie.charset.module.laser.blocks.ItemBlockJar;
import pl.asie.charset.module.laser.blocks.ItemBlockReflector;
import pl.asie.charset.module.laser.blocks.TileCrystal;
import pl.asie.charset.module.laser.blocks.TileJar;
import pl.asie.charset.module.laser.blocks.TilePrism;
import pl.asie.charset.module.laser.blocks.TileReflector;
import pl.asie.charset.module.laser.system.DummyLaserSource;
import pl.asie.charset.module.laser.system.LaserSource;
import pl.asie.charset.module.laser.system.LaserStorage;
import pl.asie.charset.module.laser.system.PacketBeamAdd;
import pl.asie.charset.module.laser.system.PacketBeamRemove;
import pl.asie.charset.module.laser.system.SubCommandDebugLasers;
import pl.asie.charset.module.laser.system.SubCommandSetSpeedOfLight;

@CharsetModule(name="laser", description="Lasers!", profile=ModuleProfile.EXPERIMENTAL)
public class CharsetLaser {
    public static final PropertyEnum<LaserColor> LASER_COLOR = PropertyEnum.func_177709_a((String)"color", LaserColor.class);
    public static final Set<Block> BLOCKING_BLOCKS = new HashSet<Block>();
    @CapabilityInject(value=LaserSource.class)
    public static Capability<LaserSource> LASER_SOURCE;
    @CapabilityInject(value=ILaserReceiver.class)
    public static Capability<ILaserReceiver> LASER_RECEIVER;
    public static final int[] LASER_COLORS;
    public static final String[] LASER_LANG_STRINGS;
    public static LaserStorage laserStorage;
    public static Block blockCrystal;
    public static Block blockReflector;
    public static Block blockJar;
    public static Block blockPrism;
    public static Item itemCrystal;
    public static Item itemReflector;
    public static Item itemJar;
    public static Item itemPrism;
    @CharsetModule.PacketRegistry
    public static PacketRegistry packet;
    @SidedProxy(modId="charset", clientSide="pl.asie.charset.module.laser.ProxyClient", serverSide="pl.asie.charset.module.laser.ProxyCommon")
    public static ProxyCommon proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(LaserSource.class, DummyCapabilityStorage.get(), DummyLaserSource::new);
        blockCrystal = new BlockCrystal();
        blockCrystal.func_149663_c("charset.laser_crystal");
        itemCrystal = new ItemBlockCrystal(blockCrystal);
        blockReflector = new BlockReflector();
        blockReflector.func_149663_c("charset.laser_reflector");
        itemReflector = new ItemBlockReflector(blockReflector);
        blockJar = new BlockJar();
        blockJar.func_149663_c("charset.light_jar");
        itemJar = new ItemBlockJar(blockJar);
        blockPrism = new BlockPrism();
        blockPrism.func_149663_c("charset.prism");
        itemPrism = new ItemBlockBase(blockPrism);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryUtils.register(event.getRegistry(), blockCrystal, "laser_crystal");
        RegistryUtils.register(event.getRegistry(), blockReflector, "laser_reflector");
        RegistryUtils.register(event.getRegistry(), blockJar, "light_jar");
        RegistryUtils.register(event.getRegistry(), blockPrism, "laser_prism");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register(event.getRegistry(), itemCrystal, "laser_crystal");
        RegistryUtils.register(event.getRegistry(), itemReflector, "laser_reflector");
        RegistryUtils.register(event.getRegistry(), itemJar, "light_jar");
        RegistryUtils.register(event.getRegistry(), itemPrism, "laser_prism");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (Block b : ForgeRegistries.BLOCKS) {
            if (!(b instanceof BlockPistonBase) && !(b instanceof BlockPistonExtension)) continue;
            BLOCKING_BLOCKS.add(b);
        }
        BLOCKING_BLOCKS.add(blockCrystal);
        BLOCKING_BLOCKS.add(blockJar);
        BLOCKING_BLOCKS.add(blockReflector);
        BLOCKING_BLOCKS.add(blockPrism);
        RegistryUtils.register(TileCrystal.class, "laser_crystal");
        RegistryUtils.register(TileReflector.class, "laser_reflector");
        RegistryUtils.register(TileJar.class, "light_jar");
        RegistryUtils.register(TilePrism.class, "laser_prism");
        FMLInterModComms.sendMessage((String)"charset", (String)"addCarry", (ResourceLocation)blockCrystal.getRegistryName());
        FMLInterModComms.sendMessage((String)"charset", (String)"addCarry", (ResourceLocation)blockReflector.getRegistryName());
        FMLInterModComms.sendMessage((String)"charset", (String)"addCarry", (ResourceLocation)blockJar.getRegistryName());
        FMLInterModComms.sendMessage((String)"charset", (String)"addCarry", (ResourceLocation)blockPrism.getRegistryName());
        packet.registerPacket(1, PacketBeamAdd.class);
        packet.registerPacket(2, PacketBeamRemove.class);
        ShiftScrollHandler.INSTANCE.register(new ShiftScrollHandler.ItemGroup(itemCrystal));
        ShiftScrollHandler.INSTANCE.register(new ShiftScrollHandler.ItemGroup(itemJar));
        ShiftScrollHandler.INSTANCE.register(new ShiftScrollHandler.ItemGroupMetadataLimited(itemReflector, 1, 7));
        ShiftScrollHandler.INSTANCE.register(new ShiftScrollHandler.ItemGroupMetadataLimited(itemReflector, 9, 15));
        MinecraftForge.EVENT_BUS.register((Object)laserStorage);
        CommandCharset.register(new SubCommandDebugLasers());
        CommandCharset.register(new SubCommandSetSpeedOfLight());
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        LASER_COLORS = new int[]{0, -1090518785, 0x4F00FF00, 0x7F00FFFF, 0x7FFF0000, -1610678017, -1879048448, -1073741825};
        LASER_LANG_STRINGS = new String[]{"charset.color.black", "charset.color.blue", "charset.color.green", "charset.color.cyan", "charset.color.red", "charset.color.magenta", "charset.color.yellow", "charset.color.white"};
        laserStorage = new LaserStorage();
    }
}

