/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.laser.LaserColor;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.command.CommandCharset;
import pl.asie.charset.lib.render.model.ModelTransformer;
import pl.asie.charset.lib.utils.Orientation;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.laser.CharsetLaser;
import pl.asie.charset.module.laser.ProxyCommon;
import pl.asie.charset.module.laser.blocks.LaserTintHandler;
import pl.asie.charset.module.laser.system.LaserRenderer;
import pl.asie.charset.module.laser.system.SubCommandDebugLasersClient;

public class ProxyClient
extends ProxyCommon {
    private static IModel prismModel;

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)new LaserRenderer());
        CommandCharset.register(new SubCommandDebugLasersClient());
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)LaserTintHandler.INSTANCE, new Block[]{CharsetLaser.blockCrystal, CharsetLaser.blockReflector, CharsetLaser.blockJar});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)LaserTintHandler.INSTANCE, new Item[]{CharsetLaser.itemCrystal, CharsetLaser.itemReflector, CharsetLaser.itemJar});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void addCustomModels(TextureStitchEvent.Pre event) {
        prismModel = RenderUtils.getModelWithTextures(new ResourceLocation("charset:block/laser_prism"), event.getMap());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void bakeModels(ModelBakeEvent event) {
        if (prismModel != null) {
            for (Orientation orientation : Orientation.values()) {
                ModelResourceLocation location = new ModelResourceLocation("charset:laser_prism", "orientation=" + orientation.name().toLowerCase());
                IBakedModel model = prismModel.bake((IModelState)orientation.toTransformation(), DefaultVertexFormats.field_176600_a, RenderUtils.textureGetter);
                event.getModelRegistry().func_82595_a((Object)location, (Object)model);
            }
        }
        for (Orientation orientation : EnumFacing.field_82609_l) {
            for (LaserColor color : LaserColor.VALUES) {
                if (color == LaserColor.NONE) continue;
                IBlockState state = CharsetLaser.blockJar.func_176223_P().func_177226_a(CharsetLaser.LASER_COLOR, (Comparable)((Object)color)).func_177226_a((IProperty)Properties.FACING, (Comparable)((Object)orientation));
                ModelResourceLocation location = new ModelResourceLocation("charset:light_jar", "color=" + color.func_176610_l() + ",facing=" + orientation.func_176610_l());
                IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
                VertexFormat format = new VertexFormat(DefaultVertexFormats.field_176599_b);
                format.func_181721_a(DefaultVertexFormats.field_181716_p);
                if (model == null) continue;
                model = ModelTransformer.transform(model, state, 0L, (quad, element, data) -> {
                    if (quad.func_178211_c() == 0 && element == DefaultVertexFormats.field_181716_p) {
                        return new float[]{0.0073243305f, 0.0f, 0.0f, 0.0f};
                    }
                    return data;
                }, bakedQuad -> {
                    if (bakedQuad.func_178211_c() == 0) {
                        return format;
                    }
                    return bakedQuad.getFormat();
                });
                event.getModelRegistry().func_82595_a((Object)location, (Object)model);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        int i;
        for (i = 0; i <= 7; ++i) {
            RegistryUtils.registerModel(CharsetLaser.itemJar, i, "charset:light_jar");
            if (i <= 0) continue;
            RegistryUtils.registerModel(CharsetLaser.itemCrystal, i, "charset:laser_crystal");
        }
        for (i = 0; i <= 16; ++i) {
            if ((i & 7) == 0) continue;
            if ((i & 8) != 0) {
                RegistryUtils.registerModel(CharsetLaser.itemReflector, i, "charset:laser_reflector#inventory_splitter");
                continue;
            }
            RegistryUtils.registerModel(CharsetLaser.itemReflector, i, "charset:laser_reflector#inventory");
        }
        RegistryUtils.registerModel(CharsetLaser.itemPrism, 0, "charset:laser_prism#orientation=face_north_point_up");
    }
}

