/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.blocks;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.laser.ILaserReceiver;
import pl.asie.charset.api.laser.LaserColor;
import pl.asie.charset.api.lib.IAxisRotatable;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.utils.Orientation;
import pl.asie.charset.module.laser.CharsetLaser;
import pl.asie.charset.module.laser.blocks.TileLaserSourceBase;

public class TilePrism
extends TileLaserSourceBase
implements IAxisRotatable {
    private final ILaserReceiver[] receivers = new ILaserReceiver[6];
    private final LaserColor[] sourceColors = new LaserColor[6];
    private Orientation orientation;

    private FaceBehaviour getFaceBehaviour(EnumFacing face) {
        if (face.func_176740_k() != this.orientation.facing.func_176740_k() && face.func_176740_k() != this.orientation.top.func_176740_k()) {
            return FaceBehaviour.PASS;
        }
        if (face == this.orientation.top || face == this.orientation.facing.func_176734_d()) {
            return FaceBehaviour.NON_DIAGONAL;
        }
        return FaceBehaviour.DIAGONAL;
    }

    private void recalcColors() {
        int i;
        LaserColor[] oldColors = new LaserColor[6];
        for (i = 0; i < 6; ++i) {
            oldColors[i] = this.colors[i];
            this.colors[i] = LaserColor.NONE;
        }
        for (i = 0; i < 6; ++i) {
            boolean isBlue;
            LaserColor source = this.sourceColors[i];
            if (source == LaserColor.NONE) continue;
            EnumFacing face = EnumFacing.func_82600_a((int)i);
            FaceBehaviour b = this.getFaceBehaviour(face);
            if (b == FaceBehaviour.PASS) {
                this.colors[i ^ 1] = this.colors[i ^ 1].union(source);
                continue;
            }
            boolean isRed = (source.ordinal() & 4) != 0;
            boolean isGreen = (source.ordinal() & 2) != 0;
            boolean bl = isBlue = (source.ordinal() & 1) != 0;
            if (isGreen) {
                this.colors[i ^ 1] = this.colors[i ^ 1].union(LaserColor.GREEN);
            }
            if (!isRed && !isBlue) continue;
            for (EnumFacing target : EnumFacing.field_82609_l) {
                FaceBehaviour targetB = this.getFaceBehaviour(target);
                if (targetB == FaceBehaviour.PASS || face.func_176740_k() == target.func_176740_k()) continue;
                if (isRed && targetB != b) {
                    this.colors[target.ordinal()] = this.colors[target.ordinal()].union(LaserColor.RED);
                }
                if (!isBlue || targetB != b) continue;
                this.colors[target.ordinal()] = this.colors[target.ordinal()].union(LaserColor.BLUE);
            }
        }
        for (i = 0; i < 6; ++i) {
            if (this.colors[i] == oldColors[i]) continue;
            CharsetLaser.laserStorage.markLaserForUpdate(this, EnumFacing.func_82600_a((int)i));
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (int i = 0; i < 6; ++i) {
            this.sourceColors[i] = LaserColor.NONE;
        }
    }

    public TilePrism() {
        for (int i = 0; i < 6; ++i) {
            int _i = i;
            this.sourceColors[i] = LaserColor.NONE;
            this.receivers[i] = color -> {
                if (this.sourceColors[_i] != color) {
                    this.sourceColors[_i] = color;
                    this.recalcColors();
                }
            };
        }
    }

    private void updateRotations() {
        this.recalcColors();
        this.markBlockForUpdate();
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        this.orientation = Orientation.fromDirection(EnumFacing.func_190914_a((BlockPos)this.func_174877_v(), (EntityLivingBase)placer));
    }

    @Override
    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        this.orientation = Orientation.getOrientation(compound.func_74771_c("o"));
        if (isClient) {
            this.markBlockForRenderUpdate();
        }
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        compound.func_74774_a("o", (byte)this.orientation.ordinal());
        return compound;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return facing != null && capability == CharsetLaser.LASER_RECEIVER || capability == Capabilities.AXIS_ROTATABLE || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == Capabilities.AXIS_ROTATABLE) {
            return (T)Capabilities.AXIS_ROTATABLE.cast((Object)this);
        }
        if (facing != null && capability == CharsetLaser.LASER_RECEIVER) {
            return (T)CharsetLaser.LASER_RECEIVER.cast((Object)this.receivers[facing.ordinal()]);
        }
        return super.getCapability(capability, facing);
    }

    private boolean changeOrientation(Orientation newOrientation, boolean simulate) {
        if (this.orientation != newOrientation) {
            if (!simulate) {
                this.orientation = newOrientation;
                this.updateRotations();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean rotateAround(EnumFacing axis, boolean simulate) {
        return this.changeOrientation(this.orientation.rotateAround(axis), simulate);
    }

    public void rotateWrench(EnumFacing axis) {
        Orientation newOrientation = axis == this.orientation.facing ? this.orientation.getPrevRotationOnFace() : Orientation.getOrientation(Orientation.fromDirection(axis).ordinal() & 0xFFFFFFFC | this.orientation.ordinal() & 3);
        this.changeOrientation(newOrientation, false);
    }

    public static enum FaceBehaviour {
        DIAGONAL,
        NON_DIAGONAL,
        PASS;

    }
}

