/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.laser.ILaserReceiver;
import pl.asie.charset.api.laser.LaserColor;
import pl.asie.charset.module.laser.CharsetLaser;
import pl.asie.charset.module.laser.blocks.BlockReflector;
import pl.asie.charset.module.laser.blocks.TileLaserSourceBase;

public class TileReflector
extends TileLaserSourceBase {
    private final ILaserReceiver[] receivers = new ILaserReceiver[6];
    private LaserColor[] bouncedColors = new LaserColor[6];
    private LaserColor[] passedColors = new LaserColor[6];
    private LaserColor[] sourceColors = new LaserColor[6];
    private LaserColor color = LaserColor.NONE;

    private void updateColor(int ri) {
        LaserColor oldColor = this.colors[ri];
        this.colors[ri] = this.passedColors[ri].union(this.bouncedColors[ri]);
        if (this.colors[ri] != oldColor) {
            CharsetLaser.laserStorage.markLaserForUpdate(this, EnumFacing.func_82600_a((int)ri));
        }
    }

    @Override
    public ItemStack getDroppedBlock(IBlockState state) {
        if (state.func_177230_c() == CharsetLaser.blockReflector) {
            return new ItemStack(CharsetLaser.blockReflector, 1, this.color.ordinal() | ((Boolean)state.func_177229_b((IProperty)BlockReflector.SPLITTER) != false ? 8 : 0));
        }
        return new ItemStack(CharsetLaser.blockReflector, 1, this.color.ordinal());
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (int i = 0; i < 6; ++i) {
            this.bouncedColors[i] = LaserColor.NONE;
            this.passedColors[i] = LaserColor.NONE;
            this.sourceColors[i] = LaserColor.NONE;
        }
    }

    public void updateSourceColor(int i) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing rotation = (EnumFacing)state.func_177229_b((IProperty)BlockReflector.ROTATION);
        if ((rotation.ordinal() & 0xFFFFFFFE) != (i & 0xFFFFFFFE)) {
            boolean isSplitter = (Boolean)state.func_177229_b((IProperty)BlockReflector.SPLITTER);
            LaserColor colorFiltered = this.sourceColors[i].intersection(this.color);
            LaserColor colorRemaining = isSplitter ? this.sourceColors[i] : this.sourceColors[i].difference(this.color);
            int ri = BlockReflector.getTargetFacing(EnumFacing.func_82600_a((int)i), rotation).ordinal();
            if (colorFiltered != this.bouncedColors[ri]) {
                this.bouncedColors[ri] = colorFiltered;
                this.updateColor(ri);
            }
            if (colorRemaining != this.passedColors[ri = i ^ 1]) {
                this.passedColors[ri] = colorRemaining;
                this.updateColor(ri);
            }
        } else {
            this.bouncedColors[i ^ 1] = LaserColor.NONE;
            if (this.passedColors[i ^ 1] != this.sourceColors[i]) {
                this.passedColors[i ^ 1] = this.sourceColors[i];
                this.updateColor(i ^ 1);
            }
        }
    }

    public TileReflector() {
        for (int i = 0; i < 6; ++i) {
            int _i = i;
            this.sourceColors[i] = LaserColor.NONE;
            this.bouncedColors[i] = LaserColor.NONE;
            this.passedColors[i] = LaserColor.NONE;
            this.receivers[i] = color -> {
                this.sourceColors[_i] = color;
                this.updateSourceColor(_i);
            };
        }
    }

    public void updateRotations() {
        int i;
        for (i = 0; i < 6; ++i) {
            this.bouncedColors[i] = LaserColor.NONE;
            this.passedColors[i] = LaserColor.NONE;
            this.colors[i] = LaserColor.NONE;
        }
        for (i = 0; i < 6; ++i) {
            this.updateSourceColor(i);
            CharsetLaser.laserStorage.markLaserForUpdate(this, EnumFacing.func_82600_a((int)i));
        }
        this.markBlockForUpdate();
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        this.color = LaserColor.VALUES[stack.func_77952_i() & 7];
    }

    @Override
    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        this.color = LaserColor.VALUES[compound.func_74771_c("color")];
        if (isClient) {
            this.markBlockForRenderUpdate();
        }
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        compound.func_74774_a("color", (byte)this.color.ordinal());
        return compound;
    }

    public LaserColor getColor() {
        return this.color;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return facing != null && capability == CharsetLaser.LASER_RECEIVER || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CharsetLaser.LASER_RECEIVER) {
            return (T)CharsetLaser.LASER_RECEIVER.cast((Object)this.receivers[facing.ordinal()]);
        }
        return super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.updateRotations();
    }
}

