/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.system;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.charset.module.laser.CharsetLaser;

public class LaserRedstoneHelper {
    private static int getLaserPower(IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (blockAccess instanceof World) {
            TileEntity tile;
            IBlockState state = blockAccess.func_180495_p(pos = pos.func_177972_a(side.func_176734_d()));
            if (state.func_177230_c().hasTileEntity(state) && (tile = blockAccess.func_175625_s(pos)) != null && tile.hasCapability(CharsetLaser.LASER_RECEIVER, side.func_176734_d())) {
                return 0;
            }
            if (CharsetLaser.laserStorage.isEndpointHit((World)blockAccess, pos, side.func_176734_d())) {
                return 15;
            }
        }
        return 0;
    }

    public static int getRedstonePower(World world, BlockPos pos, EnumFacing facing) {
        int l = LaserRedstoneHelper.getLaserPower((IBlockAccess)world, pos, facing);
        if (l == 15) {
            return l;
        }
        return Math.max(world.func_175651_c(pos, facing), l);
    }

    public static int getStrongPower(Block block, IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        int l = LaserRedstoneHelper.getLaserPower(blockAccess, pos, side);
        if (l == 15) {
            return l;
        }
        return Math.max(block.func_176211_b(blockState, blockAccess, pos, side), l);
    }
}

