/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.system;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.module.laser.CharsetLaser;
import pl.asie.charset.module.laser.system.ILaserEndpoint;
import pl.asie.charset.module.laser.system.LaserBeam;
import pl.asie.charset.module.laser.system.LaserSource;
import pl.asie.charset.patchwork.CharsetPatchwork;

public class LaserWorldStorage
implements IWorldEventListener {
    protected final Long2ObjectOpenHashMap<Set<LaserBeam>> laserBeams = new Long2ObjectOpenHashMap();
    protected final Collection<LaserBeam> laserBeamView = new Collection<LaserBeam>(){

        @Override
        public int size() {
            int size = 0;
            for (Set set : LaserWorldStorage.this.laserBeams.values()) {
                size += set.size();
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            for (Set set : LaserWorldStorage.this.laserBeams.values()) {
                if (set.size() <= 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof LaserBeam) {
                Set beamSet = (Set)LaserWorldStorage.this.laserBeams.get(ChunkPos.func_77272_a((int)(((LaserBeam)o).getStart().func_177958_n() >> 4), (int)(((LaserBeam)o).getStart().func_177952_p() >> 4)));
                return beamSet.contains(o);
            }
            return false;
        }

        @Override
        public Iterator<LaserBeam> iterator() {
            return new Iterator<LaserBeam>(){
                private final Iterator<Set<LaserBeam>> setIterator;
                private Iterator<LaserBeam> iterator;
                {
                    this.setIterator = LaserWorldStorage.this.laserBeams.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator != null && this.iterator.hasNext() || this.setIterator.hasNext();
                }

                @Override
                public LaserBeam next() {
                    while (this.iterator == null || !this.iterator.hasNext()) {
                        if (!this.setIterator.hasNext()) {
                            return null;
                        }
                        this.iterator = this.setIterator.next().iterator();
                    }
                    return this.iterator.next();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] o = new Object[this.size()];
            int i = 0;
            for (Set set : LaserWorldStorage.this.laserBeams.values()) {
                for (LaserBeam beam : set) {
                    o[i++] = beam;
                }
            }
            return o;
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            int i = 0;
            for (Set set : LaserWorldStorage.this.laserBeams.values()) {
                for (LaserBeam beam : set) {
                    if (i >= ts.length) {
                        return ts;
                    }
                    ts[i++] = beam;
                }
            }
            return ts;
        }

        @Override
        public boolean add(LaserBeam laserBeam) {
            long p = ChunkPos.func_77272_a((int)(laserBeam.getStart().func_177958_n() >> 4), (int)(laserBeam.getStart().func_177952_p() >> 4));
            LinkedHashSet<LaserBeam> beamSet = (LinkedHashSet<LaserBeam>)LaserWorldStorage.this.laserBeams.get(p);
            if (beamSet == null) {
                beamSet = new LinkedHashSet<LaserBeam>();
                LaserWorldStorage.this.laserBeams.put(p, beamSet);
            }
            return beamSet.add(laserBeam);
        }

        @Override
        public boolean remove(Object o) {
            long p;
            Set beamSet;
            if (o instanceof LaserBeam && (beamSet = (Set)LaserWorldStorage.this.laserBeams.get(p = ChunkPos.func_77272_a((int)(((LaserBeam)o).getStart().func_177958_n() >> 4), (int)(((LaserBeam)o).getStart().func_177952_p() >> 4)))) != null) {
                boolean r = beamSet.remove(o);
                if (r && beamSet.isEmpty()) {
                    LaserWorldStorage.this.laserBeams.remove(p);
                }
                return r;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object o : collection) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends LaserBeam> collection) {
            boolean a = false;
            for (LaserBeam laserBeam : collection) {
                a |= !this.add(laserBeam);
            }
            return !a;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean a = false;
            for (Object o : collection) {
                a |= !this.remove(o);
            }
            return !a;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new RuntimeException("Implement me!");
        }

        @Override
        public void clear() {
            LaserWorldStorage.this.laserBeams.clear();
        }
    };
    private final Long2ObjectOpenHashMap<Set<ILaserEndpoint>> endpoints = new Long2ObjectOpenHashMap();
    private final LongSet validatedLasers = new LongOpenHashSet();
    private final LongSet chunksToRescan = new LongOpenHashSet();
    private final Queue<BlockPos> newLasersQueue = new ArrayDeque<BlockPos>();
    protected final World world;
    private final boolean updates;
    private boolean isSearching = false;
    private Queue<Pair<TileEntity, EnumFacing>> positionsToCheck = new ArrayDeque<Pair<TileEntity, EnumFacing>>();
    Queue<LaserBeam> lasersToRespawn = new ArrayDeque<LaserBeam>();

    public LaserWorldStorage(World world, boolean updates) {
        this.world = world;
        this.updates = updates;
    }

    private void addChunkToRescan(BlockPos blockPos) {
        this.addChunkToRescan(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
    }

    private void addChunkToRescan(ChunkPos chunkPos) {
        this.addChunkToRescan(chunkPos.field_77276_a, chunkPos.field_77275_b);
    }

    private void addChunkToRescan(int x, int z) {
        this.chunksToRescan.add(ChunkPos.func_77272_a((int)x, (int)z));
    }

    protected boolean isEndpointHit(BlockPos pos, EnumFacing facing) {
        if (!CharsetPatchwork.LASER_REDSTONE) {
            throw new RuntimeException("Endpoint functionality not enabled! Please report to mod author.");
        }
        Set set = (Set)this.endpoints.get(pos.func_177986_g());
        if (set != null) {
            EnumFacing direction = facing;
            for (ILaserEndpoint endpoint : set) {
                if (endpoint.getDirection() != direction) continue;
                return true;
            }
        }
        return false;
    }

    protected void addEndpoint(ILaserEndpoint endpoint) {
        if (CharsetPatchwork.LASER_REDSTONE) {
            long k = endpoint.getPos().func_177986_g();
            HashSet<ILaserEndpoint> set = (HashSet<ILaserEndpoint>)this.endpoints.get(k);
            if (set == null) {
                set = new HashSet<ILaserEndpoint>();
                this.endpoints.put(k, set);
            }
            set.add(endpoint);
        }
    }

    protected void removeEndpoint(ILaserEndpoint endpoint) {
        long k;
        Set set;
        if (CharsetPatchwork.LASER_REDSTONE && (set = (Set)this.endpoints.get(k = endpoint.getPos().func_177986_g())) != null && set.remove(endpoint) && set.isEmpty()) {
            this.endpoints.remove(k);
        }
    }

    public Collection<LaserBeam> getLaserBeams() {
        ImmutableSet.Builder beams = new ImmutableSet.Builder();
        for (Set set : this.laserBeams.values()) {
            beams.addAll((Iterable)set);
        }
        return beams.build();
    }

    public void onTick() {
        if (this.updates) {
            this.runChunkRescanQueue();
        } else {
            this.chunksToRescan.clear();
            this.newLasersQueue.clear();
        }
    }

    private void respawnBeam(TileEntity tile, EnumFacing facing) {
        if (!this.updates) {
            return;
        }
        if (tile != null && tile.hasCapability(CharsetLaser.LASER_SOURCE, facing)) {
            this.positionsToCheck.add((Pair<TileEntity, EnumFacing>)Pair.of((Object)tile, (Object)facing));
            if (!this.isSearching) {
                this.checkPositions();
            }
        }
    }

    private void checkPositions() {
        this.isSearching = true;
        while (!this.positionsToCheck.isEmpty()) {
            EnumFacing facing;
            Pair<TileEntity, EnumFacing> pair = this.positionsToCheck.remove();
            TileEntity tile = (TileEntity)pair.getLeft();
            LaserSource src = (LaserSource)tile.getCapability(CharsetLaser.LASER_SOURCE, facing = (EnumFacing)pair.getRight());
            if (src == null) continue;
            LaserBeam oldBeam = src.getBeam();
            src.updateBeam();
            LaserBeam newBeam = src.getBeam();
            if (oldBeam == newBeam) continue;
            if (oldBeam != null) {
                oldBeam.invalidate();
                this.remove(oldBeam, false);
            }
            if (newBeam == null) continue;
            this.add(newBeam);
        }
        this.isSearching = false;
    }

    private void respawnAllBeams(TileEntity tile) {
        if (tile != null) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.respawnBeam(tile, facing);
            }
        }
    }

    private void runChunkRescanQueue() {
        while (!this.chunksToRescan.isEmpty()) {
            LongIterator it = this.chunksToRescan.iterator();
            while (it.hasNext()) {
                long cv = (Long)it.next();
                Set set = (Set)this.laserBeams.get(cv);
                if (set == null) continue;
                for (LaserBeam beam : set) {
                    if (this.validatedLasers.contains(beam.getId())) continue;
                    if (!beam.isValid()) {
                        this.lasersToRespawn.add(beam);
                        continue;
                    }
                    this.validatedLasers.add(beam.getId());
                }
            }
            this.chunksToRescan.clear();
            for (LaserBeam beam : this.lasersToRespawn) {
                this.remove(beam, false);
            }
            while (!this.lasersToRespawn.isEmpty()) {
                LaserBeam beam = this.lasersToRespawn.remove();
                this.respawnBeam(beam.getWorld().func_175625_s(beam.getStart()), beam.getDirection());
            }
        }
        this.validatedLasers.clear();
        while (!this.newLasersQueue.isEmpty()) {
            BlockPos pos = this.newLasersQueue.remove();
            this.respawnAllBeams(this.world.func_175625_s(pos));
        }
    }

    public void removeAll(Chunk chunk) {
        long l = ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b);
        Collection removedBeams = (Collection)this.laserBeams.get(l);
        if (removedBeams != null) {
            this.laserBeams.remove(l);
            for (LaserBeam laserBeam : removedBeams) {
                this.remove(laserBeam, true);
            }
        }
    }

    public boolean add(LaserBeam beam) {
        if (this.laserBeamView.add(beam)) {
            if (this.updates && CharsetPatchwork.LASER_REDSTONE) {
                this.addEndpoint(beam);
            }
            beam.onAdd(this.updates);
            return true;
        }
        return false;
    }

    public boolean remove(LaserBeam beam, boolean alreadyRemoved) {
        if (alreadyRemoved || this.laserBeamView.remove(beam)) {
            if (this.updates) {
                int t;
                if (CharsetPatchwork.LASER_REDSTONE) {
                    this.removeEndpoint(beam);
                }
                int cx1 = beam.getStart().func_177958_n() >> 4;
                int cz1 = beam.getStart().func_177952_p() >> 4;
                int cx2 = beam.getEnd().func_177958_n() >> 4;
                int cz2 = beam.getEnd().func_177952_p() >> 4;
                if (cx2 < cx1) {
                    t = cx1;
                    cx1 = cx2;
                    cx2 = t;
                }
                if (cz2 < cz1) {
                    t = cz1;
                    cz1 = cz2;
                    cz2 = t;
                }
                for (int cz = cz1; cz <= cz2; ++cz) {
                    for (int cx = cx1; cx <= cx2; ++cx) {
                        this.addChunkToRescan(cx, cz);
                    }
                }
            }
            beam.onRemove(this.updates);
            return true;
        }
        return false;
    }

    protected int getChunkRadius() {
        return 4;
    }

    public void rescanAllAffectedChunks(ChunkPos c) {
        if (this.updates) {
            this.addChunkToRescan(c);
            int chunkDiff = this.getChunkRadius();
            int chunkX = c.field_77276_a;
            int chunkZ = c.field_77275_b;
            for (int d = -chunkDiff; d <= chunkDiff; ++d) {
                this.addChunkToRescan(chunkX + d, chunkZ);
                this.addChunkToRescan(chunkX, chunkZ + d);
            }
        }
    }

    public void rescan(World worldIn, BlockPos pos) {
        this.rescanAllAffectedChunks(new ChunkPos(pos));
    }

    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        this.validatedLasers.clear();
        this.rescan(worldIn, pos);
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean p_190570_3_, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }

    public void registerLaserSources(BlockPos pos) {
        this.newLasersQueue.add(pos);
    }

    public void markLaserForUpdate(TileEntity tile, EnumFacing facing) {
        this.respawnBeam(tile, facing);
    }
}

