/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.system;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.world.World;
import pl.asie.charset.module.laser.system.LaserBeam;
import pl.asie.charset.module.laser.system.LaserWorldStorage;

public class LaserWorldStorageClient
extends LaserWorldStorage {
    private final Long2ObjectOpenHashMap<LaserBeam> beamsById = new Long2ObjectOpenHashMap();

    public LaserWorldStorageClient(World world) {
        super(world, false);
    }

    @Override
    public boolean add(LaserBeam beam) {
        if (this.beamsById.containsKey(beam.getId())) {
            return false;
        }
        if (super.add(beam)) {
            this.beamsById.put(beam.getId(), (Object)beam);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(LaserBeam beam, boolean alreadyRemoved) {
        if (super.remove(beam, alreadyRemoved)) {
            this.beamsById.remove(beam.getId());
            return true;
        }
        return false;
    }

    protected void removeById(long id) {
        LaserBeam beam = (LaserBeam)this.beamsById.get(id);
        if (beam != null) {
            this.remove(beam, false);
        }
    }
}

