/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.misc.shelf;

import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.block.BlockBase;
import pl.asie.charset.lib.item.ISubItemProvider;
import pl.asie.charset.lib.item.SubItemProviderCache;
import pl.asie.charset.lib.item.SubItemProviderRecipes;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.utils.RayTraceUtils;
import pl.asie.charset.module.misc.shelf.CharsetMiscShelf;
import pl.asie.charset.module.misc.shelf.ShelfCacheInfo;
import pl.asie.charset.module.misc.shelf.TileShelf;

public class BlockShelf
extends BlockBase
implements ITileEntityProvider {
    public static final Collection<ItemMaterial> PLANKS = new HashSet<ItemMaterial>();
    public static final AxisAlignedBB[] BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5), new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0), new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final PropertyBool BACK = PropertyBool.func_177716_a((String)"back");

    public BlockShelf() {
        super(Material.field_151575_d);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("charset.shelf");
        this.setOpaqueCube(false);
        this.setFullCube(false);
    }

    public static ItemStack createStack(ItemMaterial plankMaterial, int stackSize) {
        ItemStack scaffold = new ItemStack((Block)CharsetMiscShelf.shelfBlock, stackSize);
        scaffold.func_77982_d(new NBTTagCompound());
        plankMaterial.writeToNBT(scaffold.func_77978_p(), "plank");
        return scaffold;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND || worldIn.field_72995_K || ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING4)).func_176734_d() != facing) {
            return false;
        }
        TileShelf bookshelf = (TileShelf)worldIn.func_175625_s(pos);
        if (bookshelf != null) {
            return bookshelf.onActivated(hitX, hitY, hitZ, playerIn.func_184586_b(hand), playerIn);
        }
        return false;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileShelf bookshelf;
        if (worldIn.field_72995_K) {
            return;
        }
        IBlockState state = worldIn.func_180495_p(pos);
        RayTraceResult result = RayTraceUtils.getCollision(worldIn, pos, (EntityLivingBase)playerIn, this.func_185496_a(state, (IBlockAccess)worldIn, pos), 0);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && result.field_178784_b == ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING4)).func_176734_d() && (bookshelf = (TileShelf)worldIn.func_175625_s(pos)) != null) {
            Vec3d v = result.field_72307_f.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            bookshelf.onClicked((float)v.field_72450_a, (float)v.field_72448_b, (float)v.field_72449_c, playerIn);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOXES[((EnumFacing)state.func_177229_b((IProperty)Properties.FACING4)).ordinal() - 2 ^ ((Boolean)state.func_177229_b((IProperty)BACK) != false ? 0 : 1)];
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{Properties.FACING4, BACK}, new IUnlistedProperty[]{TileShelf.PROPERTY});
    }

    @Override
    protected ISubItemProvider createSubItemProvider() {
        return new SubItemProviderCache(new SubItemProviderRecipes(() -> CharsetMiscShelf.shelfItem));
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState base_state, BlockPos pos, EnumFacing side) {
        return (Boolean)base_state.func_177229_b((IProperty)BACK) != false && side == ((EnumFacing)base_state.func_177229_b((IProperty)Properties.FACING4)).func_176734_d() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING4)).ordinal() - 2 | ((Boolean)state.func_177229_b((IProperty)BACK) != false ? 4 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING4, (Comparable)EnumFacing.func_82600_a((int)((meta & 3) + 2))).func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(meta >= 4));
    }

    public static EnumFacing getFace(EnumFacing facing, boolean back) {
        return back ? facing.func_176734_d() : facing;
    }

    public static EnumFacing getFacePlaced(EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        Vec3d placementVec = new Vec3d((double)(hitX - 0.5f), (double)(hitY - 0.5f), (double)(hitZ - 0.5f)).func_178786_a((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e());
        placementVec = placementVec.func_178785_b(placer.func_174811_aO().func_185119_l() / 180.0f * (float)Math.PI);
        return BlockShelf.getFace(placer.func_174811_aO(), placementVec.field_72449_c > 0.0);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        Vec3d placementVec = new Vec3d((double)(hitX - 0.5f), (double)(hitY - 0.5f), (double)(hitZ - 0.5f)).func_178786_a((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e());
        placementVec = placementVec.func_178785_b(placer.func_174811_aO().func_185119_l() / 180.0f * (float)Math.PI);
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING4, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(placementVec.field_72449_c > 0.0));
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileShelf();
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return 1.0f;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileShelf bookshelf = (TileShelf)world.func_175625_s(pos);
        IExtendedBlockState extendedBS = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        if (bookshelf != null) {
            return extendedBS.withProperty(TileShelf.PROPERTY, (Object)ShelfCacheInfo.from((IBlockState)extendedBS, bookshelf));
        }
        return extendedBS;
    }
}

