/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import pl.asie.charset.lib.material.ColorLookupHandler;
import pl.asie.charset.lib.render.model.ModelColorHandler;
import pl.asie.charset.lib.render.model.ModelFactory;
import pl.asie.charset.lib.render.model.WrappedBakedModel;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.storage.barrels.BarrelCacheInfo;
import pl.asie.charset.module.storage.barrels.BlockBarrel;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;

public class BarrelModel
extends ModelFactory<BarrelCacheInfo> {
    public static final BarrelModel INSTANCE = new BarrelModel();
    public final ModelColorHandler<BarrelCacheInfo> colorizer = new ModelColorHandler<BarrelCacheInfo>((ModelFactory)this){

        @Override
        public int colorMultiplier(BarrelCacheInfo info, int tintIndex) {
            if (!info.isMetal && !info.upgrades.contains((Object)TileEntityDayBarrel.Upgrade.HOPPING)) {
                return ColorLookupHandler.INSTANCE.getColor(info.logStack, RenderUtils.AveragingMode.V_EDGES_ONLY);
            }
            return -1;
        }
    };
    public TextureAtlasSprite font = null;
    public TextureAtlasSprite front = null;
    public TextureAtlasSprite front_silky = null;
    public TextureAtlasSprite front_silky_sticky = null;
    public TextureAtlasSprite front_sticky = null;
    public TextureAtlasSprite side = null;
    public TextureAtlasSprite side_hopping = null;
    public TextureAtlasSprite side_sticky = null;
    public TextureAtlasSprite top = null;
    public TextureAtlasSprite top_hopping = null;
    public TextureAtlasSprite top_metal = null;
    public IModel template;

    public BarrelModel() {
        super(BlockBarrel.BARREL_INFO, TextureMap.field_174945_f);
        this.addDefaultBlockTransforms();
    }

    public void onTextureLoad(TextureMap map) {
        try {
            for (Field f : BarrelModel.class.getFields()) {
                if (f.getType() != TextureAtlasSprite.class) continue;
                f.set(this, map.func_174942_a(new ResourceLocation("charset:blocks/barrel/" + f.getName())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public IBakedModel bake(BarrelCacheInfo info, boolean isItem, BlockRenderLayer layer) {
        TextureAtlasSprite log = info.log;
        TextureAtlasSprite plank = info.plank;
        TextureAtlasSprite top = info.isMetal ? this.top_metal : this.top;
        TextureAtlasSprite front = this.front;
        TextureAtlasSprite side = this.side;
        if (info.upgrades.contains((Object)TileEntityDayBarrel.Upgrade.STICKY)) {
            side = this.side_sticky;
            front = info.upgrades.contains((Object)TileEntityDayBarrel.Upgrade.SILKY) ? this.front_silky_sticky : this.front_sticky;
        } else if (info.upgrades.contains((Object)TileEntityDayBarrel.Upgrade.SILKY)) {
            front = this.front_silky;
        }
        ImmutableMap.Builder textures = new ImmutableMap.Builder();
        if (isItem || layer == BlockRenderLayer.SOLID) {
            textures.put((Object)"log", (Object)log.func_94215_i());
            textures.put((Object)"plank", (Object)plank.func_94215_i());
        } else {
            textures.put((Object)"#log", (Object)"");
            textures.put((Object)"log", (Object)"");
            textures.put((Object)"#plank", (Object)"");
            textures.put((Object)"plank", (Object)"");
        }
        if (isItem || layer == BlockRenderLayer.TRANSLUCENT) {
            if (info.upgrades.contains((Object)TileEntityDayBarrel.Upgrade.HOPPING)) {
                top = this.top_hopping;
                textures.put((Object)"hopping", (Object)this.side_hopping.func_94215_i());
            } else {
                textures.put((Object)"#hopping", (Object)"");
                textures.put((Object)"hopping", (Object)"");
            }
            textures.put((Object)"top", (Object)top.func_94215_i());
            textures.put((Object)"front", (Object)front.func_94215_i());
            textures.put((Object)"side", (Object)side.func_94215_i());
        } else {
            textures.put((Object)"#top", (Object)"");
            textures.put((Object)"top", (Object)"");
            textures.put((Object)"#front", (Object)"");
            textures.put((Object)"front", (Object)"");
            textures.put((Object)"#side", (Object)"");
            textures.put((Object)"side", (Object)"");
            textures.put((Object)"#hopping", (Object)"");
            textures.put((Object)"hopping", (Object)"");
        }
        TRSRTransformation state = info.orientation.toTransformation();
        IModel retexture = this.template.retexture(textures.build());
        return new WrappedBakedModel(retexture.bake((IModelState)state, DefaultVertexFormats.field_176600_a, RenderUtils.textureGetter), log).addDefaultBlockTransforms();
    }

    @Override
    public BarrelCacheInfo fromItemStack(ItemStack stack) {
        return BarrelCacheInfo.from(stack);
    }
}

