/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import com.google.common.collect.Lists;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.storage.barrels.BarrelEventListener;
import pl.asie.charset.module.storage.barrels.BarrelModel;
import pl.asie.charset.module.storage.barrels.BlockBarrel;
import pl.asie.charset.module.storage.barrels.EntityMinecartDayBarrel;
import pl.asie.charset.module.storage.barrels.ItemDayBarrel;
import pl.asie.charset.module.storage.barrels.ItemMinecartDayBarrel;
import pl.asie.charset.module.storage.barrels.PacketBarrelCountUpdate;
import pl.asie.charset.module.storage.barrels.RenderMinecartDayBarrel;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrelRenderer;

@CharsetModule(name="storage.barrels", description="Simple barrels", profile=ModuleProfile.STABLE)
public class CharsetStorageBarrels {
    public static final List<ItemStack> CREATIVE_BARRELS = Lists.newArrayList();
    public static List<ItemStack> BARRELS = Collections.emptyList();
    public static List<ItemStack> BARRELS_NORMAL = Lists.newArrayList();
    @GameRegistry.ObjectHolder(value="chiselsandbits:block_bit")
    private static Item cb_block_bit;
    protected static TObjectIntMap<Item> stackDivisorMultiplierMap;
    protected static TObjectIntMap<Item> stackSizeMultiplierMap;
    @CharsetModule.Instance
    public static CharsetStorageBarrels instance;
    @CharsetModule.PacketRegistry
    public static PacketRegistry packet;
    @CharsetModule.Configuration
    public static Configuration config;
    public static BlockBarrel barrelBlock;
    public static ItemDayBarrel barrelItem;
    public static ItemMinecartDayBarrel barrelCartItem;
    public static boolean renderBarrelText;
    public static boolean renderBarrelItem;
    public static boolean renderBarrelItem3D;
    public static boolean enableSilkyBarrels;
    public static boolean enableStickyBarrels;
    public static boolean enableHoppingBarrels;
    public static int maxDroppedStacks;

    public static boolean isEnabled(TileEntityDayBarrel.Upgrade upgrade) {
        if (upgrade == TileEntityDayBarrel.Upgrade.SILKY) {
            return enableSilkyBarrels;
        }
        if (upgrade == TileEntityDayBarrel.Upgrade.HOPPING) {
            return enableHoppingBarrels;
        }
        if (upgrade == TileEntityDayBarrel.Upgrade.STICKY) {
            return enableStickyBarrels;
        }
        return true;
    }

    @Mod.EventHandler
    public void reloadReentrantConfig(CharsetLoadConfigEvent event) {
        enableSilkyBarrels = ConfigUtils.getBoolean(config, "features", "enableSilkyBarrels", !ModCharset.isModuleLoaded("tweak.blockCarrying"), "Enable silky barrels. On by default unless tweak.blockCarrying is also present.", true);
        enableHoppingBarrels = ConfigUtils.getBoolean(config, "features", "enableHoppingBarrels", true, "Enable hopping barrels. On by default.", true);
        enableStickyBarrels = ConfigUtils.getBoolean(config, "features", "enableStickyBarrels", true, "Enable sticky barrels. On by default.", true);
        maxDroppedStacks = ConfigUtils.getInt(config, "general", "maxDroppedStacks", 1024, 0, 0x1FFFFFF, "The maximum amount of stacks to be dropped when a barrel is broken.", true);
        renderBarrelItem3D = ConfigUtils.getBoolean(config, "render", "renderItem3D", false, "Should items use fancy 3D rendering?", false);
        renderBarrelItem = ConfigUtils.getBoolean(config, "render", "renderItem", true, "Should items be rendered on barrels?", false);
        renderBarrelText = ConfigUtils.getBoolean(config, "render", "renderText", true, "Should text be rendered on barrels?", false);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        barrelBlock = new BlockBarrel();
        barrelItem = new ItemDayBarrel(barrelBlock);
        barrelCartItem = new ItemMinecartDayBarrel();
        barrelBlock.setHarvestLevel("axe", 0);
        MinecraftForge.EVENT_BUS.register((Object)new BarrelEventListener());
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        RegistryUtils.registerModel((Item)barrelItem, 0, "charset:barrel");
        RegistryUtils.registerModel((Item)barrelCartItem, 0, "charset:barrelCart");
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryUtils.register(event.getRegistry(), barrelBlock, "barrel");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register(event.getRegistry(), barrelItem, "barrel");
        RegistryUtils.register(event.getRegistry(), barrelCartItem, "barrelCart");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntityDayBarrel.class, (String)"charset:barrel");
        RegistryUtils.register(EntityMinecartDayBarrel.class, "barrelCart", 64, 1, true);
        packet.registerPacket(1, PacketBarrelCountUpdate.class);
        FMLInterModComms.sendMessage((String)"charset", (String)"addCarry", (ResourceLocation)barrelBlock.getRegistryName());
        if (cb_block_bit != null) {
            stackDivisorMultiplierMap.put((Object)cb_block_bit, 8);
            stackSizeMultiplierMap.put((Object)cb_block_bit, 8);
        }
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        CREATIVE_BARRELS.add(TileEntityDayBarrel.makeBarrel(EnumSet.of(TileEntityDayBarrel.Upgrade.HOPPING, TileEntityDayBarrel.Upgrade.INFINITE), ItemMaterialRegistry.INSTANCE.getOrCreateMaterial(new ItemStack(Blocks.field_150357_h)), ItemMaterialRegistry.INSTANCE.getOrCreateMaterial(new ItemStack(Blocks.field_150484_ah))));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.populateBarrelStackLists();
    }

    private void populateBarrelStackLists() {
        BARRELS = barrelBlock.getSubItemProvider().getAllItems();
        BARRELS_NORMAL.clear();
        for (ItemStack is : BARRELS) {
            EnumSet<TileEntityDayBarrel.Upgrade> upgradeSet = EnumSet.noneOf(TileEntityDayBarrel.Upgrade.class);
            TileEntityDayBarrel.populateUpgrades(upgradeSet, is.func_77978_p());
            if (!upgradeSet.isEmpty()) continue;
            BARRELS_NORMAL.add(is);
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityMinecartDayBarrel.class, RenderMinecartDayBarrel::new);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDayBarrel.class, (TileEntitySpecialRenderer)new TileEntityDayBarrelRenderer());
        Minecraft.func_71410_x().func_184125_al().func_186722_a(BarrelModel.INSTANCE.colorizer, new Block[]{barrelBlock});
        Minecraft.func_71410_x().getItemColors().func_186730_a(BarrelModel.INSTANCE.colorizer, new Item[]{barrelItem});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemMinecartDayBarrel.Color(), new Item[]{barrelCartItem});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureMap(TextureStitchEvent.Pre event) {
        BarrelModel.INSTANCE.onTextureLoad(event.getMap());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPostBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:barrel", "normal"), (Object)BarrelModel.INSTANCE);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:barrel", "inventory"), (Object)BarrelModel.INSTANCE);
        BarrelModel.INSTANCE.template = RenderUtils.getModel(new ResourceLocation("charset:block/barrel"));
    }

    static {
        stackDivisorMultiplierMap = new TObjectIntHashMap();
        stackSizeMultiplierMap = new TObjectIntHashMap();
    }
}

