/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.item.ISubItemProvider;
import pl.asie.charset.lib.item.ItemMinecartCharset;
import pl.asie.charset.lib.item.SubItemProviderCache;
import pl.asie.charset.lib.material.ColorLookupHandler;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.storage.barrels.BarrelCacheInfo;
import pl.asie.charset.module.storage.barrels.CharsetStorageBarrels;
import pl.asie.charset.module.storage.barrels.EntityMinecartDayBarrel;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;

public class ItemMinecartDayBarrel
extends ItemMinecartCharset {
    public ItemMinecartDayBarrel() {
        this.func_77655_b("charset.barrelCart");
    }

    @Override
    protected EntityMinecart createCart(GameProfile owner, ItemStack cart, World world, double x, double y, double z) {
        EntityMinecartDayBarrel minecart = new EntityMinecartDayBarrel(world, x, y, z);
        minecart.initFromStack(cart);
        return minecart;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, World world, List list, ITooltipFlag verbose) {
        super.func_77624_a(is, world, list, verbose);
        CharsetStorageBarrels.barrelItem.addExtraInformation(is, world, list, verbose);
    }

    public String func_77653_i(ItemStack is) {
        if (is.func_77942_o()) {
            String name = CharsetStorageBarrels.barrelItem.func_77653_i(is);
            return I18n.func_74837_a((String)"item.charset.barrelCart.known.name", (Object[])new Object[]{name});
        }
        return super.func_77653_i(is);
    }

    @Override
    protected ISubItemProvider createSubItemProvider() {
        return new SubItemProviderCache(new ISubItemProvider(){

            private List<ItemStack> convert(Collection<ItemStack> items) {
                ArrayList<ItemStack> itemsOut = new ArrayList<ItemStack>();
                for (ItemStack barrel : items) {
                    EnumSet<TileEntityDayBarrel.Upgrade> upgradeSet = EnumSet.noneOf(TileEntityDayBarrel.Upgrade.class);
                    TileEntityDayBarrel.populateUpgrades(upgradeSet, barrel.func_77978_p());
                    if (upgradeSet.size() != 0 && !upgradeSet.contains((Object)TileEntityDayBarrel.Upgrade.INFINITE)) continue;
                    ItemStack barrelCart = ItemMinecartDayBarrel.this.makeBarrelCart(barrel);
                    itemsOut.add(barrelCart);
                }
                return itemsOut;
            }

            @Override
            public List<ItemStack> getItems() {
                return this.convert(CharsetStorageBarrels.barrelBlock.getSubItemProvider().getItems());
            }

            @Override
            public List<ItemStack> getAllItems() {
                return this.convert(CharsetStorageBarrels.barrelBlock.getSubItemProvider().getAllItems());
            }
        });
    }

    public ItemStack makeBarrelCart(ItemStack barrelItem) {
        ItemStack ret = new ItemStack((Item)this, 1, barrelItem.func_77952_i());
        ret.func_77982_d(barrelItem.func_77978_p().func_74737_b());
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Color
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            if (tintIndex == 1) {
                BarrelCacheInfo info = BarrelCacheInfo.from(stack);
                return ColorLookupHandler.INSTANCE.getColor(info.logStack, RenderUtils.AveragingMode.V_EDGES_ONLY);
            }
            return -1;
        }
    }
}

