/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.locks;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.storage.IKeyItem;
import pl.asie.charset.lib.item.IDyeableItem;
import pl.asie.charset.lib.item.ItemBase;
import pl.asie.charset.lib.ui.ItemHandlerCharset;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.module.storage.locks.LockEventHandler;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemKeyring
extends ItemBase
implements IKeyItem,
IBauble {
    public ItemKeyring() {
        this.func_77625_d(1);
        this.func_77655_b("charset.keyring");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            if (!world.field_72995_K) {
                player.openGui((Object)ModCharset.instance, 257, player.func_130014_f_(), player.field_71071_by.field_70461_c, 0, 0);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new CapabilityProvider(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            StringBuilder builder = new StringBuilder();
            int count = 0;
            int cCount = 0;
            while (compound.func_74764_b("color" + count)) {
                int color = compound.func_74762_e("color" + count);
                if (color >= 0) {
                    if (cCount > 0) {
                        if (cCount % 5 == 0) {
                            builder.append(',');
                            tooltip.add(builder.toString());
                            builder = new StringBuilder();
                        } else {
                            builder.append(", ");
                        }
                    }
                    builder.append(LockEventHandler.getColorDyed(color));
                    ++cCount;
                }
                ++count;
            }
            if (cCount > 0) {
                tooltip.add(builder.toString());
            }
        }
    }

    @Override
    public boolean canUnlock(String lock, ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack inStack = handler.getStackInSlot(i);
            if (inStack.func_190926_b() || !(inStack.func_77973_b() instanceof IKeyItem) || !((IKeyItem)inStack.func_77973_b()).canUnlock(lock, inStack)) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.TRINKET;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Color
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            int c;
            if (tintIndex > 0 && stack.func_77942_o() && stack.func_77978_p().func_74764_b("color" + (tintIndex - 1)) && (c = stack.func_77978_p().func_74762_e("color" + (tintIndex - 1))) >= 0) {
                return c;
            }
            return 16505706;
        }
    }

    private static class CapabilityProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final ItemStack stack;
        private final ItemStackHandler handler = new ItemHandlerCharset(9){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof IKeyItem ? 1 : 0;
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                int m = 0;
                int n = 0;
                for (int i = 0; i < this.getSlots(); ++i) {
                    ItemStack stackSlot = this.getStackInSlot(i);
                    if (stackSlot.func_190926_b()) continue;
                    if (stackSlot.func_77973_b() instanceof IDyeableItem) {
                        ItemUtils.getTagCompound(stack, true).func_74768_a("color" + n++, ((IDyeableItem)stackSlot.func_77973_b()).getColor(stackSlot));
                    } else {
                        ItemUtils.getTagCompound(stack, true).func_74768_a("color" + n++, -1);
                    }
                    ++m;
                }
                stack.func_77964_b(m);
            }
        };

        public CapabilityProvider(ItemStack stack) {
            this.stack = stack;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handler) : null);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("keys", (NBTBase)this.handler.serializeNBT());
            return compound;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt.func_150297_b("keys", 10)) {
                this.handler.deserializeNBT(nbt.func_74775_l("keys"));
            }
        }
    }
}

