/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.tanks;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.block.BlockBase;
import pl.asie.charset.lib.capability.CapabilityHelper;
import pl.asie.charset.module.storage.tanks.TileTank;

public class BlockTank
extends BlockBase
implements ITileEntityProvider {
    protected static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB((double)0.05f, 0.0, (double)0.05f, (double)0.95f, 1.0, (double)0.95f);
    private static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"connections", (int)0, (int)7);

    public BlockTank() {
        super(Material.field_151592_s);
        this.func_149711_c(0.6f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149663_c("charset.tank");
        this.setFullCube(false);
        this.setOpaqueCube(false);
        this.setComparatorInputOverride(true);
        this.func_149672_a(SoundType.field_185853_f);
    }

    protected int getVariant(IBlockAccess access, BlockPos pos) {
        IBlockState state = access.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockTank)) {
            return -1;
        }
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TileTank) {
            return ((TileTank)tile).getVariant();
        }
        return 0;
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        Item item = Item.func_150898_a((Block)this);
        for (int i = 0; i <= 16; ++i) {
            items.add((Object)new ItemStack(item, 1, i));
        }
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case DOWN: {
                if (this.getVariant(blockAccess, pos) == this.getVariant(blockAccess, pos.func_177977_b())) {
                    return false;
                }
                return super.func_176225_a(blockState, blockAccess, pos, side);
            }
            case UP: {
                if (this.getVariant(blockAccess, pos) == this.getVariant(blockAccess, pos.func_177984_a())) {
                    return false;
                }
                return super.func_176225_a(blockState, blockAccess, pos, side);
            }
        }
        return true;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tankEntity = worldIn.func_175625_s(pos);
        if (tankEntity instanceof TileTank) {
            TileTank tank = (TileTank)tankEntity;
            FluidStack contents = tank.getContents();
            if (contents != null) {
                return this.field_149782_v * (2.5f + (float)contents.amount * 5.0f / (float)((TileTank)tankEntity).getCapacity());
            }
            return this.field_149782_v;
        }
        return this.field_149782_v;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int variant = this.getVariant(worldIn, pos);
        int variantUp = this.getVariant(worldIn, pos.func_177984_a());
        int variantDown = this.getVariant(worldIn, pos.func_177977_b());
        return state.func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf((variantUp == variant ? 0 : 2) | (variantDown == variant ? 0 : 1) | (variant > 0 ? 4 : 0)));
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        BlockPos tankPos = pos;
        TileEntity tankEntity = worldIn.func_175625_s(tankPos);
        if (tankEntity instanceof TileTank) {
            TileTank tank = (TileTank)tankEntity;
            if (tank.fluidStack != null && tank.fluidStack.amount >= 1000) {
                float chance = (float)tank.fluidStack.amount / 8000.0f;
                if (worldIn.field_73012_v.nextFloat() <= chance) {
                    worldIn.func_175656_a(pos, tank.fluidStack.getFluid().getBlock().func_176223_P());
                }
            }
        }
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        worldIn.func_175722_b(pos, state.func_177230_c(), false);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        IFluidHandlerItem handler = (IFluidHandlerItem)CapabilityHelper.get(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, (ICapabilityProvider)stack, null);
        if (handler != null) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileTank) {
                TileTank tank = (TileTank)tile;
                if (!worldIn.field_72995_K) {
                    FluidStack fluidExtracted;
                    boolean changed = false;
                    FluidStack fluidContained = tank.getBottomTank().fluidStack;
                    if (fluidContained != null) {
                        FluidStack f = fluidContained.copy();
                        f.amount = 1000;
                        fluidExtracted = handler.drain(f, false);
                    } else {
                        fluidExtracted = handler.drain(1000, false);
                    }
                    if (fluidExtracted == null) {
                        int amount;
                        fluidExtracted = tank.drain(1000, false);
                        if (fluidExtracted != null && (amount = handler.fill(fluidExtracted, false)) > 0) {
                            fluidExtracted.amount = amount;
                            if ((fluidExtracted = tank.drain(fluidExtracted, true)) != null) {
                                handler.fill(fluidExtracted, true);
                                changed = true;
                            }
                        }
                    } else {
                        int amount = tank.fill(fluidExtracted, false);
                        if (amount > 0) {
                            fluidExtracted.amount = amount;
                            if ((fluidExtracted = handler.drain(fluidExtracted, !playerIn.func_184812_l_())) != null) {
                                tank.fill(fluidExtracted, true);
                                changed = true;
                            }
                        }
                    }
                    if (changed) {
                        playerIn.func_184201_a(EntityEquipmentSlot.MAINHAND, handler.getContainer());
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return !TileTank.checkPlacementConflict(worldIn.func_175625_s(pos.func_177977_b()), worldIn.func_175625_s(pos.func_177984_a()), -1);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockPos tankPos;
        TileEntity tankEntity;
        if ((blockIn == this || worldIn.func_175623_d(fromPos)) && (tankEntity = worldIn.func_175625_s(tankPos = pos)) instanceof TileTank) {
            ((TileTank)tankEntity).onTankStructureChanged();
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileTank();
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileTank && ((TileTank)tile).setVariant(color.func_176765_a() + 1);
    }
}

