/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.tanks;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.module.storage.tanks.BlockTank;
import pl.asie.charset.module.storage.tanks.ItemBlockTank;
import pl.asie.charset.module.storage.tanks.TankTintHandler;
import pl.asie.charset.module.storage.tanks.TileTank;
import pl.asie.charset.module.storage.tanks.TileTankRenderer;

@CharsetModule(name="storage.tanks", description="Simple BuildCraft-style vertical tanks", profile=ModuleProfile.STABLE)
public class CharsetStorageTanks {
    public static BlockTank tankBlock;
    public static Item tankItem;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        tankBlock = new BlockTank();
        tankItem = new ItemBlockTank(tankBlock);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        RegistryUtils.registerModel(tankItem, 0, "charset:fluidtank");
        for (int i = 1; i <= 16; ++i) {
            RegistryUtils.registerModel(tankItem, i, "charset:fluidtank#inventory_stained");
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryUtils.register(event.getRegistry(), tankBlock, "fluidTank");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register(event.getRegistry(), tankItem, "fluidTank");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        RegistryUtils.register(TileTank.class, "fluidTank");
        FMLInterModComms.sendMessage((String)"charset", (String)"addLock", (ResourceLocation)tankBlock.getRegistryName());
        FMLInterModComms.sendMessage((String)"charset", (String)"addCarry", (ResourceLocation)tankBlock.getRegistryName());
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)TankTintHandler.INSTANCE, new Block[]{tankBlock});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)TankTintHandler.INSTANCE, new Item[]{tankItem});
        ClientRegistry.bindTileEntitySpecialRenderer(TileTank.class, (TileEntitySpecialRenderer)new TileTankRenderer());
    }
}

