/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.tanks;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.lib.ICacheable;
import pl.asie.charset.api.lib.IDebuggable;
import pl.asie.charset.api.lib.IMovable;
import pl.asie.charset.api.lib.IMultiblockStructure;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.scheduler.Scheduler;
import pl.asie.charset.module.storage.tanks.CharsetStorageTanks;

public class TileTank
extends TileBase
implements IFluidHandler,
IFluidTankProperties,
IMovable,
IDebuggable,
IMultiblockStructure,
ICacheable {
    protected TileTank bottomTank;
    protected TileTank aboveTank;
    protected static final int CAPACITY = 16000;
    protected FluidStack fluidStack;
    private int variant;

    public static boolean checkPlacementConflict(TileEntity a, TileEntity b, int variant) {
        if (a instanceof TileTank && b instanceof TileTank && ((TileTank)a).getBottomTank().fluidStack != null && ((TileTank)b).getBottomTank().fluidStack != null && ((TileTank)a).variant == variant && ((TileTank)a).variant == ((TileTank)b).variant) {
            return !((TileTank)a).getBottomTank().fluidStack.isFluidEqual(((TileTank)b).getBottomTank().fluidStack);
        }
        return false;
    }

    public int getVariant() {
        return this.variant;
    }

    public boolean setVariant(int variant) {
        if (variant >= 0 && variant < 17 && this.variant != variant) {
            TileEntity tUp = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
            TileEntity tDown = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (!(TileTank.checkPlacementConflict(this, tUp, variant) || TileTank.checkPlacementConflict(this, tDown, variant) || TileTank.checkPlacementConflict(tUp, tDown, variant))) {
                this.variant = variant;
                this.markBlockForUpdate();
                this.field_145850_b.func_175722_b(this.field_174879_c, (Block)CharsetStorageTanks.tankBlock, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getDroppedBlock(IBlockState state) {
        return new ItemStack(state.func_177230_c(), 1, this.variant);
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        this.variant = stack.func_77952_i() % 17;
    }

    protected void onTankStructureChanged() {
        this.updateAboveTank();
        BlockPos tankPos = this.func_174877_v();
        TileTank tankEntity = this;
        while (tankEntity instanceof TileTank) {
            tankEntity.findBottomTank();
            tankPos = tankPos.func_177984_a();
            tankEntity = this.func_145831_w().func_175625_s(tankPos);
        }
        this.onStackModified();
        BlockPos below = this.func_174877_v().func_177977_b();
        TileEntity belowEntity = this.field_145850_b.func_175625_s(below);
        if (belowEntity instanceof TileTank) {
            ((TileTank)belowEntity).getBottomTank().onStackModified();
        }
    }

    protected void onStackModified() {
        if (this.fluidStack != null) {
            if (this.fluidStack.amount < 0) {
                ModCharset.logger.warn("Tank at " + this.func_174877_v() + " had negative FluidStack amount " + this.fluidStack.amount + "! This is a bug!");
            }
            if (this.fluidStack.amount <= 0) {
                this.fluidStack = null;
            }
        }
        Iterator<TileTank> tankIterator = this.getAllTanks();
        while (tankIterator.hasNext()) {
            tankIterator.next().updateComparators();
        }
        this.markBlockForUpdate();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.field_145850_b.func_175722_b(this.func_174877_v(), (Block)CharsetStorageTanks.tankBlock, false);
    }

    public void func_145829_t() {
        super.func_145829_t();
        Scheduler.INSTANCE.in(this.func_145831_w(), 1, this::updateComparators);
    }

    @Override
    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        this.variant = compound.func_74771_c("variant");
        this.fluidStack = compound.func_150297_b("fluid", 10) ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("fluid")) : null;
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        compound.func_74774_a("variant", (byte)this.variant);
        if (this.fluidStack != null) {
            NBTTagCompound fluidCpd = new NBTTagCompound();
            this.fluidStack.writeToNBT(fluidCpd);
            compound.func_74782_a("fluid", (NBTBase)fluidCpd);
        }
        return compound;
    }

    protected boolean connects(TileTank tank) {
        return tank.getVariant() == this.getVariant();
    }

    protected void updateAboveTank() {
        TileEntity nTank = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        this.aboveTank = nTank instanceof TileTank && this.connects((TileTank)nTank) && ((TileTank)nTank).connects(this) ? (TileTank)nTank : null;
    }

    protected void findBottomTank() {
        BlockPos nPos;
        TileEntity nTank;
        TileTank tank = this;
        Stack<TileTank> drainTanks = new Stack<TileTank>();
        for (int y = this.field_174879_c.func_177956_o() - 1; y >= 0 && (nTank = this.field_145850_b.func_175625_s(nPos = new BlockPos(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p()))) instanceof TileTank && this.connects((TileTank)nTank) && ((TileTank)nTank).connects(this); --y) {
            tank = (TileTank)nTank;
            drainTanks.add(tank);
        }
        this.bottomTank = tank;
        boolean fluidStackChanged = false;
        while (!drainTanks.empty() && this.fluidStack != null && this.fluidStack.amount > 0) {
            tank = (TileTank)drainTanks.pop();
            if (tank.fluidStack == null) {
                tank.fluidStack = this.fluidStack;
                this.fluidStack = null;
                fluidStackChanged = true;
            } else {
                int toAdd = Math.min(16000 - tank.fluidStack.amount, this.fluidStack.amount);
                tank.fluidStack.amount += toAdd;
                this.fluidStack.amount -= toAdd;
                if (this.fluidStack.amount == 0) {
                    this.fluidStack = null;
                }
                fluidStackChanged = true;
            }
            tank.onStackModified();
        }
        if (fluidStackChanged) {
            this.onStackModified();
        }
    }

    public Iterator<TileTank> getAllTanks() {
        return new TankIterator(this.getBottomTank());
    }

    public TileTank getBottomTank() {
        if (this.func_145831_w() == null) {
            return this;
        }
        if (this.bottomTank == null || this.bottomTank.func_145837_r()) {
            this.findBottomTank();
        }
        return this.bottomTank;
    }

    public TileTank getAboveTank() {
        if (this.func_145831_w() == null) {
            return null;
        }
        if (this.aboveTank == null || this.aboveTank.func_145837_r()) {
            this.updateAboveTank();
        }
        return this.aboveTank;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.canFillFluidType(resource)) {
            int toFill;
            int canFill;
            Iterator<TileTank> i = this.getAllTanks();
            for (toFill = resource.amount; i.hasNext() && toFill > 0; toFill -= canFill) {
                TileTank tank = i.next();
                canFill = Math.min(toFill, 16000 - (tank.fluidStack == null ? 0 : tank.fluidStack.amount));
                if (!doFill) continue;
                if (tank.fluidStack == null) {
                    tank.fluidStack = new FluidStack(resource, canFill);
                } else {
                    tank.fluidStack.amount += canFill;
                }
                tank.onStackModified();
            }
            return resource.amount - toFill;
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.canDrainFluidType(resource)) {
            return this.drain(resource.amount, doDrain);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        TileTank tank;
        int toDrain = maxDrain;
        FluidStack typeSrc = this.getBottomTank().fluidStack;
        if (typeSrc == null) {
            return null;
        }
        Stack<TileTank> drainTanks = new Stack<TileTank>();
        Iterator<TileTank> i = this.getAllTanks();
        while (i.hasNext()) {
            tank = i.next();
            if (tank.fluidStack == null) break;
            drainTanks.add(tank);
        }
        while (!drainTanks.empty() && toDrain > 0) {
            tank = (TileTank)drainTanks.pop();
            int canDrain = Math.min(toDrain, tank.fluidStack.amount);
            if (doDrain) {
                tank.fluidStack.amount -= canDrain;
                tank.onStackModified();
            }
            toDrain -= canDrain;
        }
        return new FluidStack(typeSrc, maxDrain - toDrain);
    }

    @Nullable
    public FluidStack getContents() {
        if (this.func_145831_w() == null) {
            return this.fluidStack;
        }
        Iterator<TileTank> i = this.getAllTanks();
        FluidStack contents = i.next().fluidStack;
        if (contents != null) {
            FluidStack c;
            contents = contents.copy();
            while (i.hasNext() && (c = i.next().fluidStack) != null) {
                contents.amount += c.amount;
            }
        }
        return contents;
    }

    public int getCapacity() {
        if (this.func_145831_w() == null) {
            return 16000;
        }
        int c = 0;
        Iterator<TileTank> i = this.getAllTanks();
        while (i.hasNext()) {
            c += 16000;
            i.next();
        }
        return c;
    }

    @Override
    public int getComparatorValue() {
        if (this.func_145831_w() == null) {
            return 0;
        }
        if (this.getBottomTank() != this) {
            return this.getBottomTank().getComparatorValue();
        }
        FluidStack contents = this.getContents();
        if (contents == null || contents.amount <= 0) {
            return 0;
        }
        return Math.max(1, contents.amount * 15 / this.getCapacity());
    }

    public boolean canFill() {
        return this.getBottomTank().fluidStack == null;
    }

    public boolean canDrain() {
        return this.getBottomTank().fluidStack != null;
    }

    public boolean canFillFluidType(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        this.getBottomTank();
        return this.bottomTank.fluidStack == null || this.bottomTank.fluidStack.isFluidEqual(stack);
    }

    public boolean canDrainFluidType(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        this.getBottomTank();
        return this.bottomTank.fluidStack != null && this.bottomTank.fluidStack.isFluidEqual(stack);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == Capabilities.DEBUGGABLE) {
            return true;
        }
        if (capability == Capabilities.MOVABLE) {
            return true;
        }
        if (capability == Capabilities.MULTIBLOCK_STRUCTURE) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == Capabilities.DEBUGGABLE || capability == Capabilities.MOVABLE || capability == Capabilities.MULTIBLOCK_STRUCTURE) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    private String dbgFluidToString(FluidStack stack) {
        return stack == null ? TextFormatting.ITALIC + "<empty>" : stack.getLocalizedName() + " x " + stack.amount;
    }

    @Override
    public void addDebugInformation(List<String> stringList, Side side) {
        if (side == Side.SERVER && this.field_145850_b != null) {
            stringList.add("Bottom: " + this.getBottomTank().func_174877_v());
        }
        stringList.add("Global: " + this.dbgFluidToString(this.getContents()) + TextFormatting.RESET + "/" + this.getCapacity());
        stringList.add("Local: " + this.dbgFluidToString(this.fluidStack) + TextFormatting.RESET + "/" + 16000);
    }

    @Override
    public boolean canMoveFrom() {
        return true;
    }

    @Override
    public boolean canMoveTo(World world, BlockPos pos) {
        TileEntity tUp = world.func_175625_s(pos.func_177984_a());
        TileEntity tDown = world.func_175625_s(pos.func_177977_b());
        return !TileTank.checkPlacementConflict(this, tUp, this.variant) && !TileTank.checkPlacementConflict(this, tDown, this.variant) && !TileTank.checkPlacementConflict(tUp, tDown, this.variant);
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return new BlockPosIterator(this.getBottomTank());
    }

    @Override
    public boolean contains(BlockPos pos) {
        if (pos.func_177958_n() == this.func_174877_v().func_177958_n() && pos.func_177952_p() == this.func_174877_v().func_177952_p() && pos.func_177956_o() >= this.getBottomTank().func_174877_v().func_177956_o()) {
            TileTank tank = this;
            if (pos.func_177956_o() <= tank.func_174877_v().func_177956_o()) {
                return true;
            }
            while ((tank = tank.getAboveTank()) != null) {
                if (pos.func_177956_o() > tank.func_174877_v().func_177956_o()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCacheValid() {
        return !this.func_145837_r();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        TileTank bottomTank = this.getBottomTank();
        if (bottomTank != this) {
            return new AxisAlignedBB(this.func_174877_v());
        }
        BlockPos bottomPos = this.getBottomTank().func_174877_v();
        int height = this.getCapacity() / 16000;
        return new AxisAlignedBB((double)bottomPos.func_177958_n(), (double)bottomPos.func_177956_o(), (double)bottomPos.func_177952_p(), (double)(bottomPos.func_177958_n() + 1), (double)(bottomPos.func_177956_o() + height + 1), (double)(bottomPos.func_177952_p() + 1));
    }

    private static class BlockPosIterator
    implements Iterator<BlockPos> {
        private TileTank currTank;

        public BlockPosIterator(TileTank tank) {
            this.currTank = tank;
        }

        @Override
        public boolean hasNext() {
            return this.currTank != null;
        }

        @Override
        public BlockPos next() {
            TileTank tank = this.currTank;
            this.currTank = this.currTank.getAboveTank();
            return tank.func_174877_v();
        }
    }

    public static class TankIterator
    implements Iterator<TileTank> {
        private TileTank currTank;

        public TankIterator(TileTank tank) {
            this.currTank = tank;
        }

        @Override
        public boolean hasNext() {
            return this.currTank != null;
        }

        @Override
        public TileTank next() {
            TileTank tank = this.currTank;
            this.currTank = this.currTank.getAboveTank();
            return tank;
        }
    }
}

