/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.tanks;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.lib.render.model.ModelTransformer;
import pl.asie.charset.lib.render.model.SimpleBakedModel;
import pl.asie.charset.lib.utils.ProxiedBlockAccess;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.storage.tanks.TileTank;

public class TileTankRenderer
extends FastTESR<TileTank> {
    private static final BlockModelRenderer renderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();

    private static IBlockState getFluidState(FluidStack stack, IBlockState default_state) {
        return stack.getFluid().getBlock() != null ? stack.getFluid().getBlock().func_176223_P() : default_state;
    }

    public static void renderModel(IBlockAccess access, BlockPos pos, BufferBuilder buffer, TileTank tank, FluidStack contents, int tankCount) {
        IBlockState state = TileTankRenderer.getFluidState(contents, Blocks.field_150350_a.func_176223_P());
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite sprite = map.getTextureExtry(contents.getFluid().getStill().toString());
        if (sprite == null && (sprite = map.getTextureExtry(TextureMap.field_174945_f.toString())) == null) {
            return;
        }
        float height = (float)contents.amount / 16000.0f;
        SimpleBakedModel smodel = new SimpleBakedModel();
        int color = contents.getFluid().getColor(contents);
        Vector3f from = new Vector3f(1.025f, 0.025f, 1.025f);
        Vector3f to = new Vector3f(14.975f, Math.min((float)(16 * tankCount) - 0.025f, height * 16.0f), 14.975f);
        smodel.addQuad(null, RenderUtils.createQuad(from, to, EnumFacing.DOWN, sprite, -1));
        smodel.addQuad(null, RenderUtils.createQuad(from, to, EnumFacing.UP, sprite, -1));
        int i = 0;
        while ((float)i < to.y) {
            Vector3f fromL = new Vector3f(from.x, from.y > (float)i ? from.y : (float)i, from.z);
            Vector3f toL = new Vector3f(to.x, to.y < (float)(i + 16) ? to.y : (float)(i + 16), to.z);
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                smodel.addQuad(null, RenderUtils.createQuad(fromL, toL, facing, sprite, -1));
            }
            i += 16;
        }
        SimpleBakedModel model = color == -1 ? smodel : ModelTransformer.transform(smodel, state, 0L, new FluidColorTransformer(color));
        int light = contents.getFluid().getLuminosity();
        TankBlockAccess tankAccess = new TankBlockAccess(access, light);
        renderer.func_187493_a((IBlockAccess)tankAccess, (IBakedModel)model, state, pos, buffer, false, 0L);
    }

    public void renderTileEntityFast(@Nonnull TileTank te, double x, double y, double z, float partialTicks, int destroyStage, float todo_figure_me_out, @Nonnull BufferBuilder vertexBuffer) {
        TileEntity lowerTile;
        BlockPos pos = te.func_174877_v();
        if (te.func_145831_w() != null && (lowerTile = te.func_145831_w().func_175625_s(pos.func_177977_b())) instanceof TileTank && ((TileTank)lowerTile).connects(te) && te.connects((TileTank)lowerTile)) {
            return;
        }
        if (te.func_145831_w() != null) {
            te.findBottomTank();
        }
        FluidStack contents = te.getContents();
        int tankCount = te.getCapacity() / 16000;
        if (contents == null || contents.getFluid() == null || contents.amount <= 0) {
            return;
        }
        vertexBuffer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
        TileTankRenderer.renderModel((IBlockAccess)this.func_178459_a(), pos, vertexBuffer, te, contents, tankCount);
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
    }

    private static final class TankBlockAccess
    extends ProxiedBlockAccess {
        private final int fluidLight;

        public TankBlockAccess(IBlockAccess access, int fluidLight) {
            super(access);
            this.fluidLight = fluidLight;
        }

        @Override
        public int func_175626_b(BlockPos pos, int lightValue) {
            return this.access.func_175626_b(pos, Math.max(this.fluidLight, lightValue));
        }
    }

    private static final class FluidColorTransformer
    implements ModelTransformer.IVertexTransformer {
        private final int color;

        public FluidColorTransformer(int color) {
            this.color = color;
        }

        @Override
        public float[] transform(BakedQuad quad, VertexFormatElement element, float ... data) {
            if (element.func_177375_c() == VertexFormatElement.EnumUsage.COLOR) {
                for (int i = 0; i < Math.min(data.length, 4); ++i) {
                    data[i] = data[i] * (float)(this.color >> (i < 3 ? 2 - i : i) * 8 & 0xFF) / 255.0f;
                }
            }
            return data;
        }
    }
}

