/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tools.building.chisel;

import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.RecipeUtils;
import pl.asie.charset.module.tools.building.ItemCharsetTool;
import pl.asie.charset.module.tools.building.ToolsUtils;

public class ItemChisel
extends ItemCharsetTool {
    public ItemChisel() {
        if (Loader.isModLoaded((String)"chiselsandbits")) {
            this.func_77655_b("charset.chisel.large");
        } else {
            this.func_77655_b("charset.chisel");
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    int getBlockMask(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("mask", 99)) {
            return stack.func_77978_p().func_74762_e("mask");
        }
        return 27;
    }

    void setBlockMask(ItemStack stack, int mask) {
        ItemUtils.getTagCompound(stack, true).func_74777_a("mask", (short)mask);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            if (!world.field_72995_K) {
                player.openGui((Object)ModCharset.instance, 258, player.func_130014_f_(), player.field_71071_by.field_70461_c, 0, 0);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack inputStack;
        IBlockState state;
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.PASS;
        }
        if (!(worldIn.field_72995_K || (state = worldIn.func_180495_p(pos)).func_177230_c().isAir(state, (IBlockAccess)worldIn, pos) || (inputStack = state.func_177230_c().getPickBlock(state, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos), worldIn, pos, playerIn)).func_190926_b() || inputStack.func_190916_E() != 1)) {
            ItemStack heldItem = playerIn.func_184586_b(EnumHand.MAIN_HAND);
            ItemStack[] inputStacks = new ItemStack[9];
            int inputMask = this.getBlockMask(heldItem);
            int inputCount = 0;
            for (int i = 0; i < 9; ++i) {
                if ((inputMask & 1 << i) == 0) continue;
                inputStacks[i] = inputStack;
                ++inputCount;
            }
            ItemStack result = RecipeUtils.getCraftingResult(worldIn, 3, 3, inputStacks);
            if (!(result == null || result.func_190926_b() || result.func_77973_b() instanceof ItemBlock && ((ItemBlock)result.func_77973_b()).func_179223_d() instanceof BlockButton)) {
                if (result.func_77973_b() instanceof ItemBlock) {
                    Block block = ((ItemBlock)result.func_77973_b()).func_179223_d();
                    if (block instanceof BlockButton) {
                        return EnumActionResult.FAIL;
                    }
                    if (block instanceof BlockStairs && inputCount == 6 && result.func_190916_E() >= 4 && result.func_190916_E() <= 8) {
                        result.func_190920_e(inputCount);
                    }
                }
                if (result.func_190916_E() % inputCount == 0) {
                    ItemStack resultCopy = result.func_77946_l();
                    resultCopy.func_190920_e(1);
                    ToolsUtils.placeBlockOrRollback(resultCopy, playerIn, worldIn, pos);
                    if (result.func_190916_E() > inputCount) {
                        ItemStack resultCopyRemainder = result.func_77946_l();
                        resultCopyRemainder.func_190920_e(result.func_190916_E() / inputCount - 1);
                        Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)resultCopyRemainder);
                    }
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

