/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tools.building.wrench;

import java.util.Optional;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.MultipartHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import pl.asie.charset.lib.utils.RayTraceUtils;
import pl.asie.charset.module.tools.building.CharsetToolsBuilding;
import pl.asie.charset.module.tools.building.ItemCharsetTool;
import pl.asie.charset.module.tools.building.wrench.ICustomRotateBlock;

public class ItemWrench
extends ItemCharsetTool {
    public ItemWrench() {
        this.func_77655_b("charset.wrench");
        this.setHarvestLevel("wrench", 2);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    @Optional.Method(modid="mcmultipart")
    public EnumActionResult tryRotateMultipart(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing targetFacing) {
        Optional uio = MultipartHelper.getContainer((IBlockAccess)worldIn, (BlockPos)pos);
        if (uio.isPresent()) {
            IMultipartContainer ui = (IMultipartContainer)uio.get();
            Vec3d start = RayTraceUtils.getStart((EntityLivingBase)playerIn);
            Vec3d end = RayTraceUtils.getEnd((EntityLivingBase)playerIn);
            double dist = Double.POSITIVE_INFINITY;
            IPartInfo part = null;
            for (IPartInfo p : ui.getParts().values()) {
                double d;
                RayTraceResult pResult = p.getPart().collisionRayTrace(p, start, end);
                if (pResult == null || pResult.field_72307_f == null || !((d = pResult.field_72307_f.func_72436_e(start)) <= dist)) continue;
                dist = d;
                part = p;
            }
            if (part != null) {
                return EnumActionResult.FAIL;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            EnumActionResult result;
            EnumFacing targetFacing;
            EnumFacing enumFacing = targetFacing = facing != null ? facing : EnumFacing.UP;
            if (playerIn != null && playerIn.func_70093_af()) {
                targetFacing = targetFacing.func_176734_d();
            }
            if (Loader.isModLoaded((String)"mcmultipart") && (result = this.tryRotateMultipart(playerIn, worldIn, pos, targetFacing)) != EnumActionResult.PASS) {
                return result;
            }
            IBlockState state = worldIn.func_180495_p(pos);
            if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, pos)) {
                ICustomRotateBlock customRotateBlock = CharsetToolsBuilding.getRotationHandler(state.func_177230_c());
                if (customRotateBlock != null) {
                    return customRotateBlock.rotateBlock(worldIn, pos, state, targetFacing.func_176734_d()) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
                }
                return state.func_177230_c().rotateBlock(worldIn, pos, targetFacing.func_176734_d()) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

