/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.transport.carts;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.module.transport.carts.EntityMinecartImproved;
import pl.asie.charset.module.transport.carts.TrackCombiner;
import pl.asie.charset.module.transport.carts.link.Linkable;
import pl.asie.charset.module.transport.carts.link.TrainLinker;
import pl.asie.charset.module.transport.rails.BlockRailCharset;
import pl.asie.charset.module.transport.rails.CharsetTransportRails;

@CharsetModule(name="transport.carts", description="Minecart rework. WIP", profile=ModuleProfile.TESTING)
public class CharsetTransportCarts {
    public static final Map<Class<? extends Entity>, Class<? extends EntityMinecart>> REPLACEMENT_MAP = new HashMap<Class<? extends Entity>, Class<? extends EntityMinecart>>();
    public static final ResourceLocation LINKABLE_LOC = new ResourceLocation("charsetcarts:linkable");
    @CapabilityInject(value=Linkable.class)
    public static Capability<Linkable> LINKABLE;
    @CharsetModule.Instance
    public static CharsetTransportCarts instance;
    public static TrackCombiner combiner;
    public static TrainLinker linker;
    public static Item itemLinker;
    private final Map<EntityPlayer, EntityMinecart> linkMap = new HashMap<EntityPlayer, EntityMinecart>();

    private void register(Class<? extends EntityMinecart> minecart, String name) {
        RegistryUtils.register(minecart, name, 64, 1, true);
    }

    private void register(Class<? extends EntityMinecart> minecart, String name, Class<? extends Entity> from) {
        this.register(minecart, name);
        REPLACEMENT_MAP.put(from, minecart);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(Linkable.class, (Capability.IStorage)Linkable.STORAGE, Linkable.class);
        if (ModCharset.profile.includes(ModuleProfile.INDEV)) {
            linker = new TrainLinker();
            MinecraftForge.EVENT_BUS.register((Object)linker);
            itemLinker = new Item().func_77637_a(ModCharset.CREATIVE_TAB).func_77655_b("linker").func_77625_d(1);
        }
        combiner = new TrackCombiner();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        if (ModCharset.profile.includes(ModuleProfile.INDEV)) {
            RegistryUtils.register(event.getRegistry(), itemLinker, "linker");
        }
    }

    private void registerCombinerRecipeForDirs(Block railSrc, IProperty<BlockRailBase.EnumRailDirection> propSrc, Block railDst, IProperty<BlockRailBase.EnumRailDirection> propDst, ItemStack with) {
        for (BlockRailBase.EnumRailDirection direction : propSrc.func_177700_c()) {
            if (!propDst.func_177700_c().contains(direction)) continue;
            combiner.register(railSrc.func_176223_P().func_177226_a(propSrc, (Comparable)direction), railDst.func_176223_P().func_177226_a(propDst, (Comparable)direction), with);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (ModCharset.profile.includes(ModuleProfile.INDEV)) {
            this.register(EntityMinecartImproved.class, "rminecart", EntityMinecart.class);
        }
        if (combiner != null) {
            MinecraftForge.EVENT_BUS.register((Object)combiner);
            if (ModCharset.isModuleLoaded("transport.rails")) {
                combiner.register(Blocks.field_150448_aq, CharsetTransportRails.blockRailCross.func_176223_P(), new ItemStack(Blocks.field_150448_aq));
                combiner.register(Blocks.field_150448_aq, CharsetTransportRails.blockRailCross.func_176223_P().func_177226_a(BlockRailCharset.DIRECTION, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST), new ItemStack(Blocks.field_150448_aq));
            }
            this.registerCombinerRecipeForDirs(Blocks.field_150448_aq, (IProperty<BlockRailBase.EnumRailDirection>)BlockRail.field_176565_b, Blocks.field_150319_E, (IProperty<BlockRailBase.EnumRailDirection>)BlockRailDetector.field_176573_b, new ItemStack(Blocks.field_150456_au));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @SubscribeEvent
    public void onNothingInteract(PlayerInteractEvent.RightClickEmpty event) {
        if (!event.getEntityPlayer().func_130014_f_().field_72995_K && event.getItemStack().func_77973_b() == itemLinker && this.linkMap.containsKey(event.getEntityPlayer())) {
            this.linkMap.remove(event.getEntityPlayer());
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("dev_unlinked"));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof EntityMinecart && !event.getTarget().func_130014_f_().field_72995_K && event.getItemStack().func_77973_b() == itemLinker) {
            EntityMinecart cart = (EntityMinecart)event.getTarget();
            if (this.linkMap.containsKey(event.getEntityPlayer())) {
                EntityMinecart cartOther = this.linkMap.remove(event.getEntityPlayer());
                Linkable link = linker.get((Entity)cart);
                Linkable linkOther = linker.get((Entity)cartOther);
                if (event.getEntityPlayer().func_70093_af()) {
                    if (linker.unlink(link, linkOther)) {
                        event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("dev_unlinked2"));
                    } else {
                        event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("dev_unlink2_failed"));
                    }
                } else if (link.next == null && linkOther.previous == null) {
                    linker.link(link, linkOther);
                    event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("dev_linked2"));
                } else if (link.previous == null && linkOther.next == null) {
                    linker.link(linkOther, link);
                    event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("dev_linked2"));
                } else {
                    event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("dev_link2_failed"));
                }
            } else {
                this.linkMap.put(event.getEntityPlayer(), cart);
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("dev_linked1"));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        Class<?> classy = event.getEntity().getClass();
        if (REPLACEMENT_MAP.containsKey(classy)) {
            try {
                event.setCanceled(true);
                EntityMinecart painting = REPLACEMENT_MAP.get(classy).getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(event.getWorld(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v);
                event.getWorld().func_72838_d((Entity)painting);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

