/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.transport.color;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.network.PacketEntity;
import pl.asie.charset.module.transport.color.CharsetTransportDyeableMinecarts;
import pl.asie.charset.module.transport.color.MinecartDyeable;

public class PacketMinecartUpdate
extends PacketEntity {
    private EnumDyeColor color;

    public PacketMinecartUpdate() {
    }

    public PacketMinecartUpdate(Entity entity) {
        super(entity);
    }

    public static void send(EntityMinecart minecart) {
        CharsetTransportDyeableMinecarts.packet.sendToAllAround((Packet)new PacketMinecartUpdate((Entity)minecart), (Entity)minecart, 128.0);
    }

    private static void update(EntityMinecart minecart, EnumDyeColor color) {
        MinecartDyeable properties = MinecartDyeable.get(minecart);
        if (properties != null) {
            properties.setColor(color);
        }
    }

    @Override
    public void readData(INetHandler handler, PacketBuffer buf) {
        super.readData(handler, buf);
        int intCol = buf.readInt();
        this.color = intCol < 0 ? null : EnumDyeColor.func_176764_b((int)intCol);
    }

    @Override
    public void apply(INetHandler handler) {
        if (this.entity instanceof EntityMinecart) {
            EntityMinecart minecart = (EntityMinecart)this.entity;
            PacketMinecartUpdate.update(minecart, this.color);
        }
    }

    @Override
    public void writeData(PacketBuffer buf) {
        super.writeData(buf);
        EntityMinecart minecart = (EntityMinecart)this.entity;
        MinecartDyeable properties = MinecartDyeable.get(minecart);
        buf.writeInt(properties != null && properties.getColor() != null ? properties.getColor().func_176765_a() : -1);
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }
}

