/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweaks;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.CharsetIMC;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.ThreeState;

@CharsetModule(name="tweak.doubledoors", description="Makes double doors open at the same time upon right-clicking just one", profile=ModuleProfile.STABLE)
public class CharsetTweakDoubleDoors {
    private final Set<BlockDoor> allowedDoors = new HashSet<BlockDoor>();

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (Block block : GameRegistry.findRegistry(Block.class)) {
            try {
                if (block == null || !(block instanceof BlockDoor)) continue;
                ThreeState state = CharsetIMC.INSTANCE.allows("doubleDoor", block.getRegistryName());
                boolean allowed = false;
                if (state == ThreeState.MAYBE && !block.getRegistryName().func_110624_b().equals("malisisdoors")) {
                    Class<?> c = block.getClass();
                    Method m = ReflectionHelper.findMethod(c, (String)"onBlockActivated", (String)"func_180639_a", (Class[])new Class[]{World.class, BlockPos.class, IBlockState.class, EntityPlayer.class, EnumHand.class, EnumFacing.class, Float.TYPE, Float.TYPE, Float.TYPE});
                    if (m != null && m.getDeclaringClass() == BlockDoor.class) {
                        allowed = true;
                    }
                } else if (state == ThreeState.YES) {
                    allowed = true;
                }
                if (!allowed) continue;
                this.allowedDoors.add((BlockDoor)block);
                ModCharset.logger.info("[tweak.doubledoors] Allowing " + block.getRegistryName().toString());
            }
            catch (ReflectionHelper.UnableToFindMethodException unableToFindMethodException) {}
        }
    }

    private IBlockState getActualState(IBlockAccess access, BlockPos pos) {
        IBlockState state = access.func_180495_p(pos);
        return state.func_185899_b(access, pos);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().func_70093_af() || event.getWorld().field_72995_K) {
            return;
        }
        IBlockState state = this.getActualState((IBlockAccess)event.getWorld(), event.getPos());
        Block block = state.func_177230_c();
        if (!(block instanceof BlockDoor) || !this.allowedDoors.contains(block)) {
            return;
        }
        BlockDoor door = (BlockDoor)block;
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
        boolean isOpen = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b);
        BlockDoor.EnumHingePosition isMirrored = (BlockDoor.EnumHingePosition)state.func_177229_b((IProperty)BlockDoor.field_176521_M);
        BlockPos pos = event.getPos().func_177972_a(isMirrored == BlockDoor.EnumHingePosition.RIGHT ? direction.func_176735_f() : direction.func_176746_e());
        IBlockState other = this.getActualState((IBlockAccess)event.getWorld(), pos);
        if (other.func_177230_c() == door && other.func_177229_b((IProperty)BlockDoor.field_176520_a) == direction && (Boolean)other.func_177229_b((IProperty)BlockDoor.field_176519_b) == isOpen && other.func_177229_b((IProperty)BlockDoor.field_176521_M) != isMirrored) {
            door.func_180639_a(event.getWorld(), pos, other, event.getEntityPlayer(), event.getHand(), event.getFace(), 0.0f, 0.0f, 0.0f);
        }
    }
}

