/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweaks;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;

@CharsetModule(name="tweak.mobControl", description="Allow type-based control of mob spawning.", profile=ModuleProfile.STABLE)
public class CharsetTweakMobControl {
    @CharsetModule.Configuration
    public static Configuration config;
    private Set<Class<? extends Entity>> disabledClasses = new HashSet<Class<? extends Entity>>();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        for (Object s : EntityList.func_180124_b()) {
            boolean enabled;
            Class entity = EntityList.getClass((ResourceLocation)s);
            if (entity == null || !EntityLiving.class.isAssignableFrom(entity) || (enabled = config.get("allow", s.toString(), true, null).getBoolean())) continue;
            this.disabledClasses.add(entity);
        }
        HashSet<String> enderCarrySet = new HashSet<String>();
        for (Block b : Block.field_149771_c) {
            if (!EntityEnderman.getCarriable((Block)b)) continue;
            enderCarrySet.add(b.getRegistryName().toString());
            EntityEnderman.setCarriable((Block)b, (boolean)false);
        }
        String[] enderCarry = enderCarrySet.toArray(new String[enderCarrySet.size()]);
        if (!config.hasCategory("tweaks")) {
            enderCarry = config.getStringList("endermanCarriable", "tweaks", enderCarry, "The list of blocks carriable by endermen.");
        }
        for (String s : enderCarry) {
            Block b = Block.func_149684_b((String)s);
            if (b == null || b == Blocks.field_150350_a) continue;
            EntityEnderman.setCarriable((Block)b, (boolean)true);
        }
    }

    @SubscribeEvent
    public void checkSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (this.disabledClasses.contains(event.getEntity().getClass())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void checkJoinWorld(EntityJoinWorldEvent event) {
        if (this.disabledClasses.contains(event.getEntity().getClass())) {
            event.setCanceled(true);
        }
    }
}

