/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweaks.carry;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.utils.Utils;
import pl.asie.charset.module.tweaks.carry.CharsetTweakBlockCarrying;

public class PacketCarryGrab
extends Packet {
    private EntityPlayer player;
    private Type type;
    private World world;
    private BlockPos pos;
    private Entity entity;

    public PacketCarryGrab() {
    }

    public PacketCarryGrab(World world, BlockPos pos) {
        this.world = world;
        this.type = Type.BLOCK;
        this.pos = pos;
    }

    public PacketCarryGrab(World world, Entity entity) {
        this.world = world;
        this.type = Type.ENTITY;
        this.entity = entity;
    }

    @Override
    public void readData(INetHandler handler, PacketBuffer buf) {
        int dim = buf.readInt();
        this.player = PacketCarryGrab.getPlayer(handler);
        this.type = Type.values()[buf.readByte()];
        this.world = Utils.getLocalWorld(dim);
        switch (this.type) {
            case BLOCK: {
                int x = buf.readInt();
                int y = buf.readInt();
                int z = buf.readInt();
                this.pos = new BlockPos(x, y, z);
                break;
            }
            case ENTITY: {
                int eid = buf.readInt();
                this.entity = this.world.func_73045_a(eid);
            }
        }
    }

    @Override
    public void apply(INetHandler handler) {
        if (this.player != null) {
            switch (this.type) {
                case BLOCK: {
                    CharsetTweakBlockCarrying.grabBlock(this.player, this.world, this.pos);
                    break;
                }
                case ENTITY: {
                    CharsetTweakBlockCarrying.grabEntity(this.player, this.world, this.entity);
                }
            }
        }
    }

    @Override
    public void writeData(PacketBuffer buf) {
        buf.writeInt(this.world.field_73011_w.getDimension());
        switch (this.type) {
            case BLOCK: {
                buf.writeByte(0);
                buf.writeInt(this.pos.func_177958_n());
                buf.writeInt(this.pos.func_177956_o());
                buf.writeInt(this.pos.func_177952_p());
                break;
            }
            case ENTITY: {
                buf.writeByte(1);
                buf.writeInt(this.entity.func_145782_y());
            }
        }
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }

    static enum Type {
        BLOCK,
        ENTITY;

    }
}

